/* A three-dimentional hash table
 *
 * y'know, for vertices.
 *
 * Michael Batchelder and Kacper Wysocki, February 2005
 */

/* our edge data structure */
typedef struct{
	int num_normals;
	float *v1; // vertex A
	float *v2; // vertex B
	float *n1; // normals to intersecting planes
	float *n2;
	unsigned char rn;
} edge_t;

typedef struct entry_t {
	edge_t *e;
	struct entry_t *next;
} entry_t;

typedef struct hashmod_t {
	char *name;
	struct hashmod_t *next;
	entry_t ***table;
} hashmod_t;

void init_modelhash();
edge_t *get(entry_t **table, float *v1, float *v2);
void add(entry_t **table, edge_t *e);
int get_table(char *name, int pose, entry_t ***etable_p);
void addnorm(edge_t *edge, float *n);
