/* A three-dimentional hash table
 *
 * y'know, for vertices.
 *
 * Michael Batchelder and Kacper Wysocki, February 2005
 */

#include "hash3d.h"
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>

#define TABLESIZE 1000
#define SHASHSIZE 256
#define POSES 256

int t_size = TABLESIZE;
int num_entries = 0;

hashmod_t **models;

#ifndef _WIN32
float fabsf(float x);
int hash(float *v1, float *v2){
	return ((int)fabsf(v1[0]-v2[0])) % (t_size) + ((int)fabs(v1[1]-v2[1]))% (t_size / 10)
			+  ((int)fabsf(v1[2]-v2[2])) % (t_size / 100);
}
#else
int hash(float *v1, float *v2){
	return ((int)abs(v1[0]-v2[0])) % (t_size) + ((int)abs(v1[1]-v2[1]))% (t_size / 10)
			+  ((int)abs(v1[2]-v2[2])) % (t_size / 100);
}
#endif




int strhash(char *str){
	unsigned int hash = 0;
	while(*str) hash = ((hash << 1) + *str++) % SHASHSIZE;
	return hash;
}

void init_modelhash(){
	models = calloc(SHASHSIZE,sizeof(*models));
}

int get_table(char *name, int pose, entry_t ***etable_p){
	int key = strhash(name);
	entry_t ***posetables;

	// Kacper's debug code. Polish people can be soooo crude.
	//
	// if(pose >= POSES)
	//	printf("We're fucked, and you lost the bet!\n");

	int notequal = 1;
	hashmod_t **cur = &models[key];
	if(*cur == NULL){
		*cur = calloc(1,sizeof(hashmod_t));
		(*cur)->name = name;
		posetables = (*cur)->table = calloc(POSES, sizeof(entry_t**));
	}else{
		while((notequal = strcmp(name,(*cur)->name)) != 0 && (*cur)->next){
			cur = &((*cur)->next);
		}
		if(!notequal){
			// found existing model
			// you dig? (all the poses for current model)
			posetables = (*cur)->table;
			// check it !
		}else{
			(*cur)->next = calloc(1,sizeof(hashmod_t));
			(*cur)->next->name = name;
			posetables = (*cur)->next->table = calloc(POSES,sizeof(entry_t**));
		}
	}
	// worry about overfilling this table!
	if(posetables[pose] == NULL){
		posetables[pose] = calloc(TABLESIZE,sizeof(entry_t*));
		*etable_p = posetables[pose];
		return 0; // Table is empty!
	}else{
		*etable_p = posetables[pose];
		return 1; // Table was filled already!
	}
}

float roundf(float f);

void add(entry_t **table, edge_t *e){
	int key;
	entry_t *current, *new;

	key = hash(e->v1, e->v2);

	new = (entry_t *)calloc(1, sizeof(entry_t));
	new->e = e;
	current = table[key];
	if(current == NULL){
		table[key] = new;
	}else{
		while(current->next){
			current = current->next;
		}
		current->next = new;
	}
}

edge_t *get(entry_t **table, float *v1, float *v2){
	int key;
	entry_t *current;

	key = hash(v1, v2);
	current = table[key];
	while(current){
		float *c1, *c2;
		c1 = current->e->v1;
		c2 = current->e->v2;
		if((0 == memcmp((void *) v1, (void *) c1, sizeof(float)*3) &&
			 (0 == memcmp((void *) v2, (void *) c2, sizeof(float)*3))) ||
			 (0 == memcmp((void *) v1, (void *) c2, sizeof(float)*3) &&
			 (0 == memcmp((void *) v2, (void *) c1, sizeof(float)*3)))){
			break;
		}
		current = current->next;
	}
	if (current == NULL) return NULL;
	return current->e;
}

void addnorm(edge_t *e, float *n){
	/*
	 * Debug code to make sure we're not passing nulls
	 *
	if(!e){
		printf("Edge passed was null!\n");
		abort();
	}
	if(!n){
		printf("Normal passed was null!\n");
		abort();
	}
	if(isnan(n[0]) ||isnan(n[1]) ||isnan(n[2])){
		printf("Normal passed was NaN!\n");
		abort();
	}*/
	if(e->n1 == NULL)
		e->n1 = n;
	else if (e->n1[0] == n[0] && e->n1[1] == n[1] && e->n1[2] == n[2])
		return;
	else if (e->n1[0] == -n[0] && e->n1[1] == -n[1] && e->n1[2] == -n[2])
		e->rn |= 1;
	else if (e->n2 == NULL)
		e->n2 = n;
	else if (e->n2[0] == -n[0] && e->n2[1] == -n[1] && e->n2[2] == -n[2])
		e->rn |= 2;
	else if (!(e->n2[0] == n[0] && e->n2[1] == n[1] && e->n2[2] == n[2]))
		printf("Oops, three legs bad! (%f,%f,%f)(%f,%f,%f):(%f,%f,%f)\n",
			e->n1[0],e->n1[1],e->n1[2],e->n2[0],e->n2[1],e->n2[2],n[0],n[1],n[2]);
}
