/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.overlay;

import ch.swingfx.twinkle.style.overlay.AbstractOverlay;
import ch.swingfx.twinkle.style.overlay.IOverlay;
import ch.swingfx.twinkle.style.overlay.NullOverlay;
import ch.swingfx.twinkle.style.overlay.OverlayPaintMode;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public class BorderOverlay
extends AbstractOverlay {
    private BufferedImage fImage;
    private final Color fColor;
    private final int fWidth;

    public BorderOverlay(int width, Color color, OverlayPaintMode paintMode) {
        this(width, color, paintMode, new NullOverlay());
    }

    public BorderOverlay(int width, Color color, OverlayPaintMode paintMode, IOverlay decorator) {
        super(paintMode, decorator);
        this.fWidth = width;
        this.fColor = color;
    }

    @Override
    public void paintMouseOver(Graphics g, int cornerRadius) {
        this.paintBorder(g, cornerRadius);
    }

    @Override
    public void paintMouseOut(Graphics g, int cornerRadius) {
        this.paintBorder(g, cornerRadius);
    }

    private void createBorderImage(Graphics g, int cornerRadius) {
        if (this.fImage == null) {
            Shape shape = g.getClip();
            this.fImage = new BufferedImage(shape.getBounds().width, shape.getBounds().height, 2);
            Graphics2D g2d = (Graphics2D)this.fImage.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.fColor);
            g2d.fill(new RoundRectangle2D.Double(shape.getBounds().x, shape.getBounds().y, shape.getBounds().width, shape.getBounds().height, cornerRadius, cornerRadius));
            AlphaComposite composite = AlphaComposite.Clear;
            g2d.setComposite(composite);
            int widthUsedByBorder = this.fWidth * 2;
            g2d.fill(new RoundRectangle2D.Double(new RoundRectangle2D.Double((double)((double)shape.getBounds().x), (double)((double)shape.getBounds().y), (double)((double)shape.getBounds().width), (double)((double)shape.getBounds().height), (double)((double)cornerRadius), (double)((double)cornerRadius)).getBounds().x + this.fWidth, new RoundRectangle2D.Double((double)((double)shape.getBounds().x), (double)((double)shape.getBounds().y), (double)((double)shape.getBounds().width), (double)((double)shape.getBounds().height), (double)((double)cornerRadius), (double)((double)cornerRadius)).getBounds().y + this.fWidth, new RoundRectangle2D.Double((double)((double)shape.getBounds().x), (double)((double)shape.getBounds().y), (double)((double)shape.getBounds().width), (double)((double)shape.getBounds().height), (double)((double)cornerRadius), (double)((double)cornerRadius)).getBounds().width - widthUsedByBorder, new RoundRectangle2D.Double((double)((double)shape.getBounds().x), (double)((double)shape.getBounds().y), (double)((double)shape.getBounds().width), (double)((double)shape.getBounds().height), (double)((double)cornerRadius), (double)((double)cornerRadius)).getBounds().height - widthUsedByBorder, cornerRadius, cornerRadius));
            g2d.dispose();
        }
    }

    private void paintBorder(Graphics g, int cornerRadius) {
        this.createBorderImage(g, cornerRadius);
        Graphics2D copy = (Graphics2D)g.create();
        copy.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        copy.drawImage((Image)this.fImage, 0, 0, null);
        copy.dispose();
    }
}

