/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.closebutton;

import ch.swingfx.twinkle.style.closebutton.ICloseButton;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;

public class RoundCloseButton
implements ICloseButton {
    private static final int DEFAULT_Y = 9;
    private static final int DEFAULT_X = 9;
    private static final int SIZE = 23;
    public static final int STROKE_WIDTH = 3;
    public static final int TOP_LEFT = 8;
    public static final int BOTTOM_RIGHT = 14;
    private Ellipse2D.Double fButtonShape;
    private BasicStroke fStroke;
    private Color fButtonBackgroundColor;
    private Color fButtonBorderColor;
    private BufferedImage fDropShadow;
    private int fX;
    private int fY;

    public RoundCloseButton(Color buttonBackgroundColor, Color buttonBorderColor) {
        this(buttonBackgroundColor, buttonBorderColor, 9, 9);
    }

    public RoundCloseButton(Color buttonBackgroundColor, Color buttonBorderColor, int x, int y) {
        this.withPosition(x, y);
        this.fStroke = new BasicStroke(3.0f);
        this.fButtonBackgroundColor = buttonBackgroundColor;
        this.fButtonBorderColor = buttonBorderColor;
        try {
            this.fDropShadow = ImageIO.read(RoundCloseButton.class.getResourceAsStream("/ch/swingfx/twinkle/style/closebutton/resources/roundCloseButtonDropShadow.png"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void paintCloseButton(Graphics g) {
        Graphics2D copy = (Graphics2D)g.create();
        copy.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.fDropShadow != null) {
            copy.drawImage((Image)this.fDropShadow, this.fX, this.fY, null);
        }
        copy.setColor(this.fButtonBackgroundColor);
        copy.fill(this.fButtonShape);
        copy.setStroke(this.fStroke);
        copy.setColor(this.fButtonBorderColor);
        copy.draw(this.fButtonShape);
        copy.drawLine(this.fX + 8, this.fY + 8, this.fX + 14, this.fY + 14);
        copy.drawLine(this.fX + 14, this.fY + 8, this.fX + 8, this.fY + 14);
        copy.dispose();
    }

    @Override
    public boolean isMouseOverCloseButton(Point mousePosition) {
        if (mousePosition == null || this.fButtonShape == null) {
            return false;
        }
        return this.fButtonShape.contains(mousePosition);
    }

    @Override
    public ICloseButton withPosition(int x, int y) {
        this.fX = x;
        this.fY = y;
        this.fButtonShape = new Ellipse2D.Double(this.fX, this.fY, 23.0, 23.0);
        return this;
    }
}

