/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.background;

import ch.swingfx.color.ColorUtil;
import ch.swingfx.twinkle.style.background.IBackground;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;

public class GradientBackground
implements IBackground {
    private Color fStartColor;
    private Color fEndColor;

    public GradientBackground(Color startColor, Color endColor) {
        this.fStartColor = startColor;
        this.fEndColor = endColor;
    }

    @Override
    public void paintBackground(Graphics g, boolean isMouseOver, int cornerRadius) {
        Graphics2D g2d = (Graphics2D)g.create();
        Shape clip = g2d.getClip();
        Rectangle bounds = clip.getBounds();
        GradientPaint gp = new GradientPaint(new Point2D.Float(bounds.x, bounds.y), this.fStartColor, new Point2D.Float(bounds.x, bounds.y + bounds.height), this.fEndColor);
        g2d.setPaint(gp);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (cornerRadius == 0) {
            g2d.fill(clip);
        } else {
            g2d.fill(new RoundRectangle2D.Double(0.0, 0.0, clip.getBounds().getWidth(), clip.getBounds().getHeight(), cornerRadius, cornerRadius));
        }
        g2d.dispose();
    }

    @Override
    public void setAlpha(float alpha) {
        this.fStartColor = ColorUtil.withAlpha(this.fStartColor, alpha);
        this.fEndColor = ColorUtil.withAlpha(this.fEndColor, alpha);
    }
}

