/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.manger;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.LinkedList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JWindow;
import javax.swing.Timer;

public class SequentialNotificationManager {
    private static final int DELAY = 90;
    private static final Lock sLock;
    private static final LinkedList<JWindow> sWindows;
    private static boolean sWindowOpen;

    static {
        sWindowOpen = false;
        sLock = new ReentrantLock(true);
        sWindows = new LinkedList();
    }

    private SequentialNotificationManager() {
    }

    protected static void showNotification(final JWindow window) {
        try {
            sLock.lock();
            sWindows.addLast(window);
            window.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    window.removeWindowListener(this);
                    sWindowOpen = false;
                    SequentialNotificationManager.nextWindow();
                }
            });
            SequentialNotificationManager.nextWindow();
        }
        finally {
            sLock.unlock();
        }
    }

    private static void nextWindow() {
        try {
            sLock.lock();
            if (!sWindowOpen && sWindows.size() > 0) {
                sWindowOpen = true;
                final JWindow window = sWindows.removeFirst();
                Timer delayVisibleTimer = new Timer(90, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Timer t = (Timer)e.getSource();
                        t.stop();
                        window.setVisible(true);
                        window.getGlassPane().setVisible(true);
                    }
                });
                delayVisibleTimer.start();
            }
        }
        finally {
            sLock.unlock();
        }
    }
}

