/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.main;

import ch.swingfx.twinkle.errorHandling.ErrorDialog;
import ch.swingfx.twinkle.main.ColorNotification;
import ch.swingfx.twinkle.main.NotificationManager;
import ch.swingfx.twinkle.main.OverFlowPage;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class SettingsPage
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextArea txtrColorChosen;
    private JTextArea senderFilterDescription;
    private JCheckBox booleanFilterSender;
    private JFormattedTextField groupFilterContent;
    private JFormattedTextField senderFilterContent;
    private JFormattedTextField channelFilterContent;
    private JButton sendTestBtn;
    private JCheckBox booleanContentMessage;
    private JCheckBox booleanFilterChannel;
    private JCheckBox booleanFilterGroup;
    private JComboBox locationSelection;
    private JTextArea channelFilterDescription;
    private JTextArea groupFilterDescription;
    private JCheckBox booleanContentPicture;
    private JButton btnSaveNotification;
    private JCheckBox booleanContentSender;
    private JCheckBox booleanContentChannel;
    private JCheckBox booleanContentGroup;
    private JColorChooser colorChooser;
    private Color color;
    private JSlider timeSlider;
    private JButton btnChooseBackgroundColor;
    private JComboBox booleanTextColor;
    private JTextArea txtrTextColor;
    private String textColor;
    private ColorNotification curNotification;

    public SettingsPage() {
        this.init();
        this.populateView();
        this.curNotification = new ColorNotification();
    }

    private void init() {
        this.setDefaultCloseOperation(3);
        this.setBounds(200, 100, 800, 600);
        this.contentPane = new JPanel();
        this.contentPane.setBackground(new Color(240, 248, 255));
        this.contentPane.setBorder(new LineBorder(new Color(51, 102, 204), 50));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JTextArea txtrSlackNotificationSettings = new JTextArea();
        txtrSlackNotificationSettings.setForeground(new Color(240, 248, 255));
        txtrSlackNotificationSettings.setText("Slack Notification Settings Page");
        txtrSlackNotificationSettings.setFont(new Font("Helvetica Neue", 1, 18));
        txtrSlackNotificationSettings.setBackground(new Color(51, 102, 204));
        txtrSlackNotificationSettings.setBounds(280, 18, 320, 23);
        txtrSlackNotificationSettings.setEditable(false);
        this.contentPane.add(txtrSlackNotificationSettings);
    }

    private void populateView() {
        this.color = Color.white;
        this.textColor = "Black";
        this.makeColorSelections();
        this.makeSoundSelections();
        this.makeSendTestButton();
        this.makeTimeSlider();
        this.makeContentSelection();
        this.makeFilters();
        this.makeLocationSelection();
        this.makeSaveNotification();
        this.addListeners();
    }

    private void makeSoundSelections() {
    }

    private void makeLocationSelection() {
        JTextArea txtrWhereShouldThe = new JTextArea();
        txtrWhereShouldThe.setText("Where should the notification be shown on the screen?");
        txtrWhereShouldThe.setFont(new Font("Helvetica Neue", 0, 15));
        txtrWhereShouldThe.setBackground(new Color(240, 248, 255));
        txtrWhereShouldThe.setBounds(63, 199, 379, 32);
        txtrWhereShouldThe.setEditable(false);
        this.contentPane.add(txtrWhereShouldThe);
        this.locationSelection = new JComboBox();
        this.locationSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"Top Right", "Center", "Top Left"}));
        this.locationSelection.setBounds(459, 197, 157, 27);
        this.contentPane.add(this.locationSelection);
    }

    private void makeFilters() {
        JTextArea txtrWhichSenderChannel = new JTextArea();
        txtrWhichSenderChannel.setText("Which sender, channel or slack group does this notification setting apply to? \n(Check all that apply)");
        txtrWhichSenderChannel.setFont(new Font("Helvetica Neue", 0, 15));
        txtrWhichSenderChannel.setBackground(new Color(240, 248, 255));
        txtrWhichSenderChannel.setBounds(70, 356, 642, 42);
        txtrWhichSenderChannel.setEditable(false);
        this.contentPane.add(txtrWhichSenderChannel);
        this.channelFilterDescription = new JTextArea();
        this.channelFilterDescription.setText("Channel:");
        this.channelFilterDescription.setFont(new Font("Helvetica Neue", 0, 12));
        this.channelFilterDescription.setBackground(new Color(240, 248, 255));
        this.channelFilterDescription.setBounds(276, 430, 118, 16);
        this.channelFilterDescription.setEditable(false);
        this.contentPane.add(this.channelFilterDescription);
        this.channelFilterDescription.setVisible(false);
        this.booleanFilterChannel = new JCheckBox("Channel");
        this.booleanFilterChannel.setBounds(147, 426, 128, 23);
        this.contentPane.add(this.booleanFilterChannel);
        this.booleanFilterChannel.setFont(new Font("Helvetica Neue", 0, 12));
        this.groupFilterDescription = new JTextArea();
        this.groupFilterDescription.setText("Slack Group:");
        this.groupFilterDescription.setFont(new Font("Helvetica Neue", 0, 12));
        this.groupFilterDescription.setBackground(new Color(240, 248, 255));
        this.groupFilterDescription.setBounds(276, 461, 118, 23);
        this.groupFilterDescription.setEditable(false);
        this.contentPane.add(this.groupFilterDescription);
        this.groupFilterDescription.setVisible(false);
        this.booleanFilterGroup = new JCheckBox("Slack Group");
        this.booleanFilterGroup.setBounds(147, 458, 128, 23);
        this.contentPane.add(this.booleanFilterGroup);
        this.booleanFilterGroup.setFont(new Font("Helvetica Neue", 0, 12));
        this.senderFilterDescription = new JTextArea();
        this.senderFilterDescription.setText("Sender Name:");
        this.senderFilterDescription.setFont(new Font("Helvetica Neue", 0, 12));
        this.senderFilterDescription.setBackground(new Color(240, 248, 255));
        this.senderFilterDescription.setBounds(276, 402, 118, 16);
        this.senderFilterDescription.setEditable(false);
        this.contentPane.add(this.senderFilterDescription);
        this.senderFilterDescription.setVisible(false);
        this.booleanFilterSender = new JCheckBox("Sender");
        this.booleanFilterSender.setBounds(147, 397, 128, 23);
        this.contentPane.add(this.booleanFilterSender);
        this.booleanFilterSender.setFont(new Font("Helvetica Neue", 0, 12));
        this.groupFilterContent = new JFormattedTextField();
        this.groupFilterContent.setBounds(391, 455, 180, 26);
        this.contentPane.add(this.groupFilterContent);
        this.groupFilterContent.setVisible(false);
        this.senderFilterContent = new JFormattedTextField();
        this.senderFilterContent.setBounds(391, 395, 180, 26);
        this.contentPane.add(this.senderFilterContent);
        this.senderFilterContent.setVisible(false);
        this.channelFilterContent = new JFormattedTextField();
        this.channelFilterContent.setBounds(391, 425, 180, 26);
        this.contentPane.add(this.channelFilterContent);
        this.channelFilterContent.setVisible(false);
    }

    private void makeContentSelection() {
        JTextArea txtrWhatInformationShould = new JTextArea();
        txtrWhatInformationShould.setText("What information should be shown on the notification? (Check all that apply)");
        txtrWhatInformationShould.setFont(new Font("Helvetica Neue", 0, 15));
        txtrWhatInformationShould.setBackground(new Color(240, 248, 255));
        txtrWhatInformationShould.setBounds(60, 143, 511, 23);
        txtrWhatInformationShould.setEditable(false);
        this.contentPane.add(txtrWhatInformationShould);
        this.booleanContentSender = new JCheckBox("Sender");
        this.booleanContentSender.setFont(new Font("Helvetica Neue", 0, 12));
        this.booleanContentSender.setBounds(190, 164, 128, 23);
        this.contentPane.add(this.booleanContentSender);
        this.booleanContentChannel = new JCheckBox("Channel");
        this.booleanContentChannel.setFont(new Font("Helvetica Neue", 0, 12));
        this.booleanContentChannel.setBounds(443, 164, 128, 23);
        this.contentPane.add(this.booleanContentChannel);
        this.booleanContentGroup = new JCheckBox("Slack Group");
        this.booleanContentGroup.setFont(new Font("Helvetica Neue", 0, 12));
        this.booleanContentGroup.setBounds(584, 164, 128, 23);
        this.contentPane.add(this.booleanContentGroup);
        this.booleanContentMessage = new JCheckBox("Message");
        this.booleanContentMessage.setBounds(65, 164, 128, 23);
        this.contentPane.add(this.booleanContentMessage);
        this.booleanContentMessage.setFont(new Font("Helvetica Neue", 0, 12));
        this.booleanContentPicture = new JCheckBox("Picture");
        this.booleanContentPicture.setFont(new Font("Helvetica Neue", 0, 12));
        this.booleanContentPicture.setBounds(316, 164, 128, 23);
        this.contentPane.add(this.booleanContentPicture);
    }

    private void makeColorSelections() {
        JTextArea txtrWhatBackgroundColor = new JTextArea();
        txtrWhatBackgroundColor.setText("What color should the notification be?");
        txtrWhatBackgroundColor.setFont(new Font("Helvetica Neue", 0, 12));
        txtrWhatBackgroundColor.setBackground(new Color(240, 248, 255));
        txtrWhatBackgroundColor.setBounds(64, 61, 428, 16);
        txtrWhatBackgroundColor.setEditable(false);
        this.contentPane.add(txtrWhatBackgroundColor);
        this.txtrColorChosen = new JTextArea();
        this.txtrColorChosen.setFont(new Font("Helvetica Neue", 0, 12));
        this.txtrColorChosen.setBounds(308, 79, 37, 23);
        this.txtrColorChosen.setEditable(false);
        this.contentPane.add(this.txtrColorChosen);
        this.txtrTextColor = new JTextArea();
        this.txtrTextColor.setText("Text color:");
        this.txtrTextColor.setFont(new Font("Helvetica Neue", 0, 15));
        this.txtrTextColor.setBackground(new Color(240, 248, 255));
        this.txtrTextColor.setBounds(64, 110, 77, 25);
        this.txtrTextColor.setEditable(false);
        this.contentPane.add(this.txtrTextColor);
        this.btnChooseBackgroundColor = new JButton("Choose Background Color");
        this.btnChooseBackgroundColor.setBounds(60, 79, 232, 27);
        this.contentPane.add(this.btnChooseBackgroundColor);
        this.booleanTextColor = new JComboBox();
        this.booleanTextColor.setModel(new DefaultComboBoxModel<String>(new String[]{"Black", "White"}));
        this.booleanTextColor.setBounds(150, 106, 174, 32);
        this.contentPane.add(this.booleanTextColor);
    }

    private void makeTimeSlider() {
        JTextArea txtrNotificationDurationIn = new JTextArea();
        txtrNotificationDurationIn.setFont(new Font("Helvetica Neue", 0, 15));
        txtrNotificationDurationIn.setBackground(new Color(240, 248, 255));
        txtrNotificationDurationIn.setText("How long should the notification be shown for? (in seconds)");
        txtrNotificationDurationIn.setBounds(64, 237, 428, 32);
        txtrNotificationDurationIn.setEditable(false);
        this.contentPane.add(txtrNotificationDurationIn);
        this.timeSlider = new JSlider();
        this.timeSlider.setMinimum(1);
        this.timeSlider.setFont(new Font("Helvetica Neue", 0, 11));
        this.timeSlider.setPaintTicks(true);
        this.timeSlider.setPaintLabels(true);
        this.timeSlider.setSnapToTicks(true);
        this.timeSlider.setMajorTickSpacing(1);
        this.timeSlider.setMaximum(5);
        this.timeSlider.setBounds(60, 258, 404, 61);
        this.contentPane.add(this.timeSlider);
    }

    private void makeSendTestButton() {
        this.sendTestBtn = new JButton("Send Test Notification");
        this.sendTestBtn.setBackground(new Color(255, 215, 0));
        this.sendTestBtn.setForeground(new Color(0, 0, 0));
        this.sendTestBtn.setBounds(308, 334, 208, 23);
        this.contentPane.add(this.sendTestBtn);
    }

    private void makeSaveNotification() {
        this.btnSaveNotification = new JButton("Save Notification");
        this.btnSaveNotification.setForeground(Color.BLACK);
        this.btnSaveNotification.setBackground(new Color(255, 215, 0));
        this.btnSaveNotification.setBounds(308, 500, 208, 23);
        this.contentPane.add(this.btnSaveNotification);
        JButton btnGoToNotification = new JButton("Notification Manager >");
        btnGoToNotification.setForeground(Color.BLACK);
        btnGoToNotification.setBackground(new Color(240, 255, 255));
        btnGoToNotification.setBounds(619, 6, 163, 38);
        this.contentPane.add(btnGoToNotification);
        btnGoToNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationManager.getInstance().setVisible(true);
                SettingsPage.this.setVisible(false);
            }
        });
    }

    private void addListeners() {
        this.btnChooseBackgroundColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPage.this.colorChooser = new JColorChooser();
                JDialog dialog = JColorChooser.createDialog(null, "Choose a Color for the Notification", false, SettingsPage.this.colorChooser, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        SettingsPage.this.color = SettingsPage.this.colorChooser.getColor();
                        SettingsPage.this.txtrColorChosen.setBackground(SettingsPage.this.colorChooser.getColor());
                    }
                }, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                    }
                });
                dialog.setVisible(true);
            }
        });
        this.booleanFilterSender.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPage.this.booleanFilterSender.isSelected()) {
                    SettingsPage.this.senderFilterDescription.setVisible(true);
                    SettingsPage.this.senderFilterContent.setVisible(true);
                } else {
                    SettingsPage.this.senderFilterDescription.setVisible(false);
                    SettingsPage.this.senderFilterContent.setVisible(false);
                }
            }
        });
        this.booleanFilterGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPage.this.booleanFilterGroup.isSelected()) {
                    SettingsPage.this.groupFilterDescription.setVisible(true);
                    SettingsPage.this.groupFilterContent.setVisible(true);
                } else {
                    SettingsPage.this.groupFilterDescription.setVisible(false);
                    SettingsPage.this.groupFilterContent.setVisible(false);
                }
            }
        });
        this.booleanFilterChannel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SettingsPage.this.booleanFilterChannel.isSelected()) {
                    SettingsPage.this.channelFilterDescription.setVisible(true);
                    SettingsPage.this.channelFilterContent.setVisible(true);
                } else {
                    SettingsPage.this.channelFilterDescription.setVisible(false);
                    SettingsPage.this.channelFilterContent.setVisible(false);
                }
            }
        });
        this.sendTestBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPage.this.curNotification.setStyle(SettingsPage.this.booleanTextColor.getSelectedItem().toString(), SettingsPage.this.color);
                SettingsPage.this.curNotification.setContent(SettingsPage.this.booleanContentMessage.isSelected(), SettingsPage.this.booleanContentSender.isSelected(), SettingsPage.this.booleanContentPicture.isSelected(), SettingsPage.this.booleanContentChannel.isSelected(), SettingsPage.this.booleanContentGroup.isSelected());
                SettingsPage.this.curNotification.setPosition(SettingsPage.this.locationSelection.getSelectedItem().toString());
                SettingsPage.this.curNotification.setTimeDuration(SettingsPage.this.timeSlider.getValue());
                ColorNotification.play(SettingsPage.this.curNotification);
            }
        });
        this.btnSaveNotification.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPage.this.curNotification.setStyle(SettingsPage.this.booleanTextColor.getSelectedItem().toString(), SettingsPage.this.color);
                SettingsPage.this.curNotification.setContent(SettingsPage.this.booleanContentMessage.isSelected(), SettingsPage.this.booleanContentSender.isSelected(), SettingsPage.this.booleanContentPicture.isSelected(), SettingsPage.this.booleanContentChannel.isSelected(), SettingsPage.this.booleanContentGroup.isSelected());
                SettingsPage.this.curNotification.setPosition(SettingsPage.this.locationSelection.getSelectedItem().toString());
                SettingsPage.this.curNotification.setTimeDuration(SettingsPage.this.timeSlider.getValue());
                if (SettingsPage.this.booleanFilterSender.isSelected() && SettingsPage.this.senderFilterContent.getText().isEmpty() || SettingsPage.this.booleanFilterChannel.isSelected() && SettingsPage.this.channelFilterContent.getText().isEmpty() || SettingsPage.this.booleanFilterGroup.isSelected() && SettingsPage.this.groupFilterContent.getText().isEmpty()) {
                    ErrorDialog ErrorDialog2 = new ErrorDialog("Error! Notification setting \nselected, but description \nis empty!");
                    ErrorDialog2.setVisible(true);
                } else if (!(SettingsPage.this.booleanFilterSender.isSelected() || SettingsPage.this.booleanFilterChannel.isSelected() || SettingsPage.this.booleanFilterGroup.isSelected())) {
                    ErrorDialog ErrorDialog3 = new ErrorDialog("Error! Please select at \nleast one filter!");
                    ErrorDialog3.setVisible(true);
                } else {
                    SettingsPage.this.curNotification.addFilters(SettingsPage.this.booleanFilterSender.isSelected(), SettingsPage.this.senderFilterContent.getText(), SettingsPage.this.booleanFilterChannel.isSelected(), SettingsPage.this.channelFilterContent.getText(), SettingsPage.this.booleanFilterGroup.isSelected(), SettingsPage.this.groupFilterContent.getText());
                    if (NotificationManager.getInstance().savedNotifications.size() + OverFlowPage.getInstance().toDisplay.size() > 10) {
                        ErrorDialog ErrorDialog4 = new ErrorDialog("Maximum notification \nsettings exceeded, please \ndelete a setting in \norder to add more.");
                        ErrorDialog4.setVisible(true);
                    } else {
                        NotificationManager.getInstance().addNotification(SettingsPage.this.curNotification);
                        NotificationManager.getInstance().setVisible(true);
                        SettingsPage.this.setVisible(false);
                    }
                }
            }
        });
    }
}

