/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.main;

import ch.swingfx.twinkle.main.ColorNotification;
import ch.swingfx.twinkle.main.NotificationManager;
import ch.swingfx.twinkle.main.SettingsPage;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class OverFlowPage
extends JFrame {
    private static final long serialVersionUID = 1L;
    JPanel contentPane = new JPanel();
    private JButton goToSettings;
    JScrollPane scrollPane;
    private static OverFlowPage INSTANCE = new OverFlowPage();
    ArrayList<ColorNotification> toDisplay = new ArrayList();

    public static OverFlowPage getInstance() {
        return INSTANCE;
    }

    private OverFlowPage() {
        this.init();
    }

    void init() {
        this.setDefaultCloseOperation(3);
        this.setBounds(200, 100, 800, 600);
        this.contentPane.setBackground(new Color(240, 248, 255));
        this.contentPane.setBorder(new LineBorder(new Color(51, 102, 204), 50));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JTextArea filterTitle = new JTextArea();
        filterTitle.setEditable(false);
        filterTitle.setText("Filter:");
        filterTitle.setBackground(new Color(240, 248, 255));
        filterTitle.setFont(new Font("Helvetica Neue", 0, 14));
        filterTitle.setBounds(151, 50, 100, 15);
        this.contentPane.add(filterTitle);
        JTextArea notificationPreviewTitle = new JTextArea();
        notificationPreviewTitle.setEditable(false);
        notificationPreviewTitle.setText("Notification Preview:");
        notificationPreviewTitle.setBackground(new Color(240, 248, 255));
        notificationPreviewTitle.setFont(new Font("Helvetica Neue", 0, 14));
        notificationPreviewTitle.setBounds(322, 50, 140, 15);
        this.contentPane.add(notificationPreviewTitle);
        JTextArea txtrSlackNotificationSettings = new JTextArea();
        txtrSlackNotificationSettings.setForeground(new Color(240, 248, 255));
        txtrSlackNotificationSettings.setText("Slack Notification Manager");
        txtrSlackNotificationSettings.setFont(new Font("Helvetica Neue", 1, 18));
        txtrSlackNotificationSettings.setBackground(new Color(51, 102, 204));
        txtrSlackNotificationSettings.setBounds(280, 18, 231, 23);
        txtrSlackNotificationSettings.setEditable(false);
        this.contentPane.add(txtrSlackNotificationSettings);
        this.goToSettings = new JButton("< New Notification");
        this.goToSettings.setForeground(Color.BLACK);
        this.goToSettings.setBackground(new Color(240, 255, 255));
        this.goToSettings.setBounds(6, 6, 163, 38);
        this.contentPane.add(this.goToSettings);
        JButton backPageButton = new JButton("<");
        backPageButton.setForeground(Color.BLACK);
        backPageButton.setBackground(new Color(240, 255, 255));
        backPageButton.setBounds(353, 534, 43, 38);
        this.contentPane.add(backPageButton);
        backPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationManager.getInstance().displayNotifications();
                NotificationManager.getInstance().contentPane.repaint();
                NotificationManager.getInstance().contentPane.revalidate();
                NotificationManager.getInstance().setVisible(true);
                OverFlowPage.getInstance().setVisible(false);
            }
        });
        this.goToSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPage settings = new SettingsPage();
                settings.setVisible(true);
                OverFlowPage.this.setVisible(false);
            }
        });
    }

    public void addNotification(ColorNotification curNotification) {
        this.displayNotifications();
    }

    void displayNotifications() {
        this.contentPane.removeAll();
        this.init();
        int yPos = 69;
        int z = 0;
        while (z < this.toDisplay.size()) {
            final ColorNotification x = this.toDisplay.get(z);
            x.display(yPos);
            this.contentPane.add(x.notificationPreview);
            this.contentPane.add(x.playButton);
            this.contentPane.add(x.removeButton);
            if (x.picture) {
                this.contentPane.add(x.imageHolder);
            }
            x.playButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ColorNotification.play(x);
                }
            });
            this.buildRemoveButton(x);
            this.contentPane.add(x.filterContent);
            x.filterContent.setVisible(true);
            System.out.println(x);
            yPos += 111;
            ++z;
        }
    }

    private void buildRemoveButton(final ColorNotification x) {
        x.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog CancelCheck = new JDialog();
                CancelCheck.setBounds(460, 200, 320, 150);
                CancelCheck.setVisible(true);
                CancelCheck.getContentPane().setLayout(null);
                JTextArea txtrAreYouSure = new JTextArea();
                txtrAreYouSure.setBackground(SystemColor.window);
                txtrAreYouSure.setText("Are you sure you want to delete this notification setting?");
                txtrAreYouSure.setFont(new Font("Helvetica Neue", 0, 12));
                txtrAreYouSure.setEditable(false);
                txtrAreYouSure.setBounds(10, 20, 366, 16);
                CancelCheck.getContentPane().add(txtrAreYouSure);
                JButton btnYes = new JButton("Yes, Delete");
                btnYes.setFont(new Font("Helvetica Neue", 0, 12));
                btnYes.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("OverFlowPage");
                        (this).OverFlowPage.this.toDisplay.remove(x);
                        NotificationManager.getInstance().savedNotifications.remove(x);
                        NotificationManager.getInstance().contentPane.removeAll();
                        NotificationManager.getInstance().init();
                        NotificationManager.getInstance().displayNotifications();
                        NotificationManager.getInstance().contentPane.repaint();
                        NotificationManager.getInstance().contentPane.revalidate();
                        OverFlowPage.this.displayNotifications();
                        (this).OverFlowPage.this.toDisplay.size();
                        CancelCheck.setVisible(false);
                    }
                });
                btnYes.setBounds(20, 70, 100, 29);
                CancelCheck.getContentPane().add(btnYes);
                JButton btnNoKeep = new JButton("No, Keep");
                btnNoKeep.setFont(new Font("Helvetica Neue", 0, 12));
                btnNoKeep.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CancelCheck.dispose();
                        CancelCheck.setVisible(false);
                    }
                });
                btnNoKeep.setBounds(200, 70, 100, 29);
                CancelCheck.getContentPane().add(btnNoKeep);
            }
        });
    }
}

