/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.main;

import ch.swingfx.twinkle.main.ColorNotification;
import ch.swingfx.twinkle.main.OverFlowPage;
import ch.swingfx.twinkle.main.SettingsPage;
import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.LineBorder;

public class NotificationManager
extends JFrame {
    private static final long serialVersionUID = -8053382896629589825L;
    private static NotificationManager INSTANCE = new NotificationManager();
    private JButton backButton;
    ArrayList<ColorNotification> savedNotifications;
    ArrayList<ColorNotification> overflow;
    JPanel contentPane = new JPanel();

    public static NotificationManager getInstance() {
        return INSTANCE;
    }

    private NotificationManager() {
        this.init();
        this.savedNotifications = new ArrayList();
    }

    void init() {
        this.setDefaultCloseOperation(3);
        this.setBounds(200, 100, 800, 600);
        this.contentPane.setBackground(new Color(240, 248, 255));
        this.contentPane.setBorder(new LineBorder(new Color(51, 102, 204), 50));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        JTextArea filterTitle = new JTextArea();
        filterTitle.setEditable(false);
        filterTitle.setText("Filter:");
        filterTitle.setBackground(new Color(240, 248, 255));
        filterTitle.setFont(new Font("Helvetica Neue", 0, 14));
        filterTitle.setBounds(151, 50, 100, 15);
        this.contentPane.add(filterTitle);
        JTextArea notificationPreviewTitle = new JTextArea();
        notificationPreviewTitle.setEditable(false);
        notificationPreviewTitle.setText("Notification Preview:");
        notificationPreviewTitle.setBackground(new Color(240, 248, 255));
        notificationPreviewTitle.setFont(new Font("Helvetica Neue", 0, 14));
        notificationPreviewTitle.setBounds(322, 50, 140, 15);
        this.contentPane.add(notificationPreviewTitle);
        JTextArea txtrSlackNotificationSettings = new JTextArea();
        txtrSlackNotificationSettings.setForeground(new Color(240, 248, 255));
        txtrSlackNotificationSettings.setText("Slack Notification Manager");
        txtrSlackNotificationSettings.setFont(new Font("Helvetica Neue", 1, 18));
        txtrSlackNotificationSettings.setBackground(new Color(51, 102, 204));
        txtrSlackNotificationSettings.setBounds(280, 18, 231, 23);
        txtrSlackNotificationSettings.setEditable(false);
        this.contentPane.add(txtrSlackNotificationSettings);
        this.backButton = new JButton("< New Notification");
        this.backButton.setForeground(Color.BLACK);
        this.backButton.setBackground(new Color(240, 255, 255));
        this.backButton.setBounds(6, 6, 163, 38);
        this.contentPane.add(this.backButton);
        this.backButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsPage settings = new SettingsPage();
                settings.setVisible(true);
                NotificationManager.this.setVisible(false);
            }
        });
    }

    public void addNotification(ColorNotification curNotification) {
        this.savedNotifications.add(curNotification);
        this.displayNotifications();
    }

    public void displayNotifications() {
        this.contentPane.removeAll();
        this.init();
        int yPos = 69;
        if (this.savedNotifications.size() > 4) {
            int delta;
            this.overflow = new ArrayList();
            JButton newPageButton = this.makeForwardButton();
            yPos = this.populateNotificationManagerPage(yPos);
            int z = delta = this.savedNotifications.size() - 5;
            while (z >= 0) {
                ColorNotification x = this.savedNotifications.get(z);
                this.overflow.add(x);
                --z;
            }
            OverFlowPage.getInstance().toDisplay = this.overflow;
            newPageButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    OverFlowPage.getInstance().contentPane.removeAll();
                    OverFlowPage.getInstance().init();
                    OverFlowPage.getInstance().displayNotifications();
                    OverFlowPage.getInstance().contentPane.repaint();
                    OverFlowPage.getInstance().contentPane.revalidate();
                    OverFlowPage.getInstance().setVisible(true);
                    NotificationManager.getInstance().setVisible(false);
                }
            });
        } else {
            int z = this.savedNotifications.size() - 1;
            while (z >= 0) {
                yPos = this.buildNotificationDisplay(yPos, z);
                --z;
            }
        }
    }

    private int buildNotificationDisplay(int yPos, int z) {
        final ColorNotification x = this.savedNotifications.get(z);
        x.display(yPos);
        this.contentPane.add(x.notificationPreview);
        this.contentPane.add(x.playButton);
        this.contentPane.add(x.removeButton);
        if (x.picture) {
            this.contentPane.add(x.imageHolder);
        }
        x.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorNotification.play(x);
            }
        });
        this.buildRemoveButton(x);
        this.contentPane.add(x.filterContent);
        x.filterContent.setVisible(true);
        return yPos += 111;
    }

    private int populateNotificationManagerPage(int yPos) {
        int z = this.savedNotifications.size() - 1;
        while (this.savedNotifications.size() - 4 <= z) {
            yPos = this.buildNotificationDisplay(yPos, z);
            --z;
        }
        return yPos;
    }

    private JButton makeForwardButton() {
        JButton newPageButton = new JButton(">");
        newPageButton.setForeground(Color.BLACK);
        newPageButton.setBackground(new Color(240, 255, 255));
        newPageButton.setBounds(353, 534, 43, 38);
        this.contentPane.add(newPageButton);
        return newPageButton;
    }

    private void buildRemoveButton(final ColorNotification x) {
        x.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JDialog CancelCheck = new JDialog();
                CancelCheck.setBounds(460, 200, 320, 150);
                CancelCheck.setVisible(true);
                CancelCheck.getContentPane().setLayout(null);
                JTextArea txtrAreYouSure = new JTextArea();
                txtrAreYouSure.setBackground(SystemColor.window);
                txtrAreYouSure.setText("Are you sure you want to delete this notification setting?");
                txtrAreYouSure.setFont(new Font("Helvetica Neue", 0, 12));
                txtrAreYouSure.setEditable(false);
                txtrAreYouSure.setBounds(10, 20, 366, 16);
                CancelCheck.getContentPane().add(txtrAreYouSure);
                JButton btnYes = new JButton("Yes, Delete");
                btnYes.setFont(new Font("Helvetica Neue", 0, 12));
                btnYes.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        (this).NotificationManager.this.savedNotifications.remove(x);
                        (this).NotificationManager.this.contentPane.removeAll();
                        NotificationManager.this.init();
                        NotificationManager.this.displayNotifications();
                        (this).NotificationManager.this.contentPane.repaint();
                        (this).NotificationManager.this.contentPane.revalidate();
                        CancelCheck.setVisible(false);
                    }
                });
                btnYes.setBounds(20, 70, 100, 29);
                CancelCheck.getContentPane().add(btnYes);
                JButton btnNoKeep = new JButton("No, Keep");
                btnNoKeep.setFont(new Font("Helvetica Neue", 0, 12));
                btnNoKeep.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CancelCheck.dispose();
                        CancelCheck.setVisible(false);
                    }
                });
                btnNoKeep.setBounds(200, 70, 100, 29);
                CancelCheck.getContentPane().add(btnNoKeep);
            }
        });
    }
}

