/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.main;

import ch.swingfx.twinkle.event.NotificationEvent;
import ch.swingfx.twinkle.event.NotificationEventAdapter;
import ch.swingfx.twinkle.main.Starter;
import ch.swingfx.twinkle.manger.NotificationManagers;
import ch.swingfx.twinkle.style.INotificationStyle;
import ch.swingfx.twinkle.style.theme.ColorNotificationStyle;
import ch.swingfx.twinkle.style.theme.NotificationBuilder;
import ch.swingfx.twinkle.window.Positions;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;

public class ColorNotification {
    private int time;
    private boolean message;
    private boolean sender;
    private boolean channel;
    private boolean group;
    private Positions position;
    private INotificationStyle style;
    Color color;
    boolean picture;
    String senderFilter;
    String channelFilter;
    String groupFilter;
    String textColor;
    JTextPane filterContent;
    JTextPane notificationPreview;
    JButton playButton;
    JButton removeButton;
    JTextPane imageHolder;

    public void setStyle(String textColor, Color color) {
        this.textColor = textColor;
        this.color = color;
        this.style = new ColorNotificationStyle(textColor, color).withWidth(400).withAlpha(0.9f);
    }

    public void display(int yPos) {
        this.filterContent = new JTextPane();
        this.filterContent.setBounds(150, yPos, 148, 83);
        this.filterContent.setFont(new Font("Helvetica Neue", 0, 11));
        this.filterContent.setEditable(false);
        this.buildFilter();
        if (this.picture) {
            ImageIcon displayFace = new ImageIcon(Starter.class.getResource("/ch/swingfx/twinkle/resource/Boss.jpg"));
            this.notificationPreview = new JTextPane();
            this.notificationPreview.setBounds(421, yPos, 230, 83);
            this.notificationPreview.setBackground(this.color);
            this.notificationPreview.setEditable(false);
            this.buildNotificationPreview(yPos);
            this.imageHolder = new JTextPane();
            this.imageHolder.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.imageHolder.setBounds(321, yPos, 100, 83);
            this.imageHolder.setEditable(false);
            this.imageHolder.insertIcon(displayFace);
            this.imageHolder.setBackground(this.color);
        } else {
            this.notificationPreview = new JTextPane();
            this.notificationPreview.setBounds(321, yPos, 330, 65);
            this.notificationPreview.setBackground(this.color);
            this.notificationPreview.setEditable(false);
            this.notificationPreview.setBorder(new EmptyBorder(-11, 10, 4, 4));
            this.buildNotificationPreview(yPos);
        }
        this.playButton = new JButton("Play");
        this.playButton.setFont(new Font("Helvetica Neue", 0, 12));
        this.playButton.setBounds(57, yPos + 15, 79, 29);
        this.removeButton = new JButton("X");
        this.removeButton.setFont(new Font("Helvetica Neue", 0, 12));
        this.removeButton.setBounds(690, yPos, 38, 29);
    }

    private void buildNotificationPreview(int yPos) {
        String senderString = " ";
        String groupString = "";
        String channelString = "";
        String messageString = "";
        if (this.sender) {
            senderString = "Jack ";
        }
        if (this.channel) {
            channelString = "#General ";
        }
        if (this.group) {
            groupString = "Microsoft ";
        }
        if (this.message) {
            messageString = "Example message content.";
        }
        String header = String.valueOf(senderString) + groupString + channelString;
        String body = messageString;
        this.notificationPreview.setContentType("text/html");
        if (this.textColor.equals("White")) {
            this.notificationPreview.setText("<html> <p style = \" font-family: Lucida Grande; font-size: 10px; color:white\">  <b>" + header + "</b><br/><br/>" + body + "</p></html>");
        } else {
            this.notificationPreview.setText("<html> <p style = \" font-family: Lucida Grande; font-size: 10px;\">  <b>" + header + "</b><br/><br/>" + body + "</p></html>");
        }
        JTextArea headerText = new JTextArea();
        headerText.setEditable(false);
        headerText.setText(header);
    }

    private void buildFilter() {
        String groupFilter = this.groupFilter;
        String senderFilter = this.senderFilter;
        String channelFilter = this.channelFilter;
        groupFilter = groupFilter != null ? "Group: \n" + this.groupFilter + "\n" : "";
        senderFilter = senderFilter != null ? "Sender: \n" + this.senderFilter + "\n" : "";
        channelFilter = channelFilter != null ? "Channel: \n" + this.channelFilter : "";
        this.filterContent.setText(String.valueOf(senderFilter) + groupFilter + channelFilter);
    }

    public void setContent(boolean message, boolean sender, boolean picture, boolean channel, boolean group) {
        this.message = message;
        this.sender = sender;
        this.picture = picture;
        this.channel = channel;
        this.group = group;
    }

    public void setPosition(String pos) {
        this.position = pos.equals("Top Left") ? Positions.NORTH_WEST : (pos.equals("Center") ? Positions.CENTER : Positions.NORTH_EAST);
    }

    public static void play(ColorNotification curNotification) {
        ImageIcon face = null;
        String senderString = " ";
        String groupString = "";
        String channelString = "";
        String messageString = "";
        if (curNotification.sender) {
            senderString = "Jack ";
        }
        if (curNotification.channel) {
            channelString = "#General ";
        }
        if (curNotification.group) {
            groupString = "Microsoft ";
        }
        if (curNotification.picture) {
            face = new ImageIcon(Starter.class.getResource("/ch/swingfx/twinkle/resource/Boss.jpg"));
        }
        if (curNotification.message) {
            messageString = "Example message content.";
        }
        new NotificationBuilder().withStyle(curNotification.style).withTitle(String.valueOf(senderString) + groupString + channelString).withMessage(messageString).withIcon(face).withNotificationManager(NotificationManagers.SEQUENTIAL).withDisplayTime(curNotification.time * 1000).withPosition(curNotification.position).withListener(new NotificationEventAdapter(){

            @Override
            public void closed(NotificationEvent event) {
            }

            @Override
            public void clicked(NotificationEvent event) {
            }
        }).showNotification();
    }

    public void setTimeDuration(int time) {
        this.time = time;
    }

    public void addFilters(boolean senderOn, String senderText, boolean channelOn, String channelText, boolean groupOn, String groupText) {
        this.senderFilter = senderOn ? senderText : null;
        this.channelFilter = channelOn ? channelText : null;
        this.groupFilter = groupOn ? groupText : null;
    }
}

