/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.color;

import java.awt.Color;

public final class ColorUtil {
    private ColorUtil() {
    }

    public static Color withAlpha(Color color, float alpha) {
        int newAlpha = ColorUtil.floatAlphaToIntAlpha(alpha);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), newAlpha);
    }

    public static int floatAlphaToIntAlpha(float alpha) {
        if (alpha < 0.0f || alpha > 1.0f) {
            throw new IllegalArgumentException("alpha must be between 0f and 1f. value: " + alpha);
        }
        return (int)(255.0f * alpha);
    }
}

