/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.window.translucentandshaped;

import ch.swingfx.window.translucentandshaped.ApiType;
import ch.swingfx.window.translucentandshaped.ITranslucentAndShapedWindowApi;
import ch.swingfx.window.translucentandshaped.Translucency;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Shape;
import java.awt.Window;
import java.lang.reflect.Method;

public class OfficialApi
implements ITranslucentAndShapedWindowApi {
    private static final int OPAQUE = 255;
    private static final int NOT_OPAQUE = 0;
    private static boolean isSupported = false;
    private static Object PERPIXEL_TRANSPARENT;
    private static Object TRANSLUCENT;
    private static Object PERPIXEL_TRANSLUCENT;
    private static Method isTranslucencySupported;
    private static Method setWindowOpacity;
    private static Method getWindowOpacity;
    private static Method setWindowShape;
    private static Method getWindowShape;
    private static Method isTranslucencyCapable;

    static {
        try {
            Class<?> translucencyClass = Class.forName("java.awt.GraphicsDevice$WindowTranslucency");
            Method valueOf = translucencyClass.getMethod("valueOf", String.class);
            PERPIXEL_TRANSPARENT = valueOf.invoke(translucencyClass, "PERPIXEL_TRANSPARENT");
            TRANSLUCENT = valueOf.invoke(translucencyClass, "TRANSLUCENT");
            PERPIXEL_TRANSLUCENT = valueOf.invoke(translucencyClass, "PERPIXEL_TRANSLUCENT");
            isTranslucencySupported = GraphicsDevice.class.getMethod("isWindowTranslucencySupported", translucencyClass);
            setWindowOpacity = Window.class.getMethod("setOpacity", Float.TYPE);
            getWindowOpacity = Window.class.getMethod("getOpacity", new Class[0]);
            setWindowShape = Window.class.getMethod("setShape", Shape.class);
            getWindowShape = Window.class.getMethod("getShape", new Class[0]);
            isTranslucencyCapable = GraphicsConfiguration.class.getMethod("isTranslucencyCapable", new Class[0]);
            isSupported = true;
        }
        catch (Exception e) {
            isSupported = false;
        }
    }

    public static boolean isSupported() {
        return isSupported;
    }

    @Override
    public boolean isTranslucencySupported(Translucency translucencyKind, GraphicsDevice gd) {
        Object kind = null;
        switch (translucencyKind) {
            case PERPIXEL_TRANSLUCENT: {
                kind = PERPIXEL_TRANSLUCENT;
                break;
            }
            case TRANSLUCENT: {
                kind = TRANSLUCENT;
                break;
            }
            case PERPIXEL_TRANSPARENT: {
                kind = PERPIXEL_TRANSPARENT;
            }
        }
        try {
            return (Boolean)isTranslucencySupported.invoke((Object)gd, kind);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void setWindowOpacity(Window window, float opacity) {
        try {
            setWindowOpacity.invoke((Object)window, Float.valueOf(opacity));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public float getWindowOpacity(Window window) {
        try {
            return ((Float)getWindowOpacity.invoke((Object)window, new Object[0])).floatValue();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 1.0f;
        }
    }

    @Override
    public void setWindowShape(Window window, Shape shape) {
        try {
            setWindowShape.invoke((Object)window, shape);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Shape getWindowShape(Window window) {
        try {
            return (Shape)getWindowShape.invoke((Object)window, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setWindowOpaque(Window window, boolean isOpaque) {
        if (!this.isTranslucencyCapable(window.getGraphicsConfiguration()) || !this.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT, window.getGraphicsConfiguration().getDevice())) {
            return;
        }
        Color background = window.getBackground();
        int alpha = isOpaque ? 255 : 0;
        window.setBackground(new Color(background.getRed(), background.getGreen(), background.getBlue(), alpha));
    }

    @Override
    public boolean isWindowOpaque(Window window) {
        return window.getBackground().getAlpha() == 255;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration gc) {
        try {
            return (Boolean)isTranslucencyCapable.invoke((Object)gc, new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public ApiType getApiType() {
        return ApiType.OFFICIAL;
    }
}

