/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.window;

import ch.swingfx.twinkle.style.INotificationStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JPanel;
import javax.swing.JWindow;

public class GlassPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    private final JWindow fWindow;
    private final INotificationStyle fStyle;
    private final int fCornerRadius;

    public GlassPane(JWindow window, INotificationStyle style, int cornerRadius) {
        super.setOpaque(false);
        this.fWindow = window;
        this.fStyle = style;
        this.fCornerRadius = cornerRadius;
        this.fWindow.setGlassPane(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D copy = (Graphics2D)g.create();
        copy.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.fWindow.getMousePosition() != null) {
            this.fStyle.getOverlay().paintOverlayMouseOver(copy, this.fCornerRadius);
            this.fStyle.getCloseButton().paintCloseButton(copy);
        } else {
            this.fStyle.getOverlay().paintOverlayMouseOut(copy, this.fCornerRadius);
        }
        copy.dispose();
    }
}

