/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.window;

import ch.swingfx.text.TextUtil;
import ch.swingfx.twinkle.style.INotificationStyle;
import ch.swingfx.twinkle.style.background.BackgroundPainterPanel;
import ch.swingfx.window.translucentandshaped.ITranslucentAndShapedWindowApi;
import ch.swingfx.window.translucentandshaped.Translucency;
import ch.swingfx.window.translucentandshaped.TranslucentAndShapedWindowApiFactory;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JWindow;
import javax.swing.plaf.basic.BasicTextAreaUI;

public class DefaultNotificationWindow
extends JWindow {
    private static final long serialVersionUID = 1L;
    public static final String OVERRIDE_ICON_INSETS = String.valueOf(DefaultNotificationWindow.class.getName()) + "-icon-insets";
    public static final String OVERRIDE_TITLE_INSETS = String.valueOf(DefaultNotificationWindow.class.getName()) + "-title-insets";
    public static final String OVERRIDE_MESSAGE_INSETS = String.valueOf(DefaultNotificationWindow.class.getName()) + "-message-insets";
    private static final Insets sIconInsets = new Insets(10, 5, 10, 10);
    private static final Insets sTitleLabelInsets = new Insets(10, 0, 5, 10);
    private static final Insets sMessageLabelInsets = new Insets(0, 0, 10, 10);

    public DefaultNotificationWindow(Icon icon, String title, String message, INotificationStyle style, GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        int iconHeight;
        int preferredHeight;
        JTextArea fMessageLabel;
        Map<String, Object> customParams = style.getCustomParams();
        Insets fIconInsets = sIconInsets;
        if (customParams.containsKey(OVERRIDE_ICON_INSETS)) {
            fIconInsets = (Insets)customParams.get(OVERRIDE_ICON_INSETS);
        }
        Insets fTitleLabelInsets = sTitleLabelInsets;
        if (customParams.containsKey(OVERRIDE_TITLE_INSETS)) {
            fTitleLabelInsets = (Insets)customParams.get(OVERRIDE_TITLE_INSETS);
        }
        Insets fMessageLabelInsets = sMessageLabelInsets;
        if (customParams.containsKey(OVERRIDE_MESSAGE_INSETS)) {
            fMessageLabelInsets = (Insets)customParams.get(OVERRIDE_MESSAGE_INSETS);
        }
        int cornerRadius = 0;
        ITranslucentAndShapedWindowApi api = TranslucentAndShapedWindowApiFactory.getApi();
        if (api.isTranslucencyCapable(graphicsConfiguration) && api.isTranslucencySupported(Translucency.PERPIXEL_TRANSLUCENT, graphicsConfiguration.getDevice())) {
            cornerRadius = style.getWindowCornerRadius();
        }
        BackgroundPainterPanel fContentPane = new BackgroundPainterPanel(style.getBackground(), cornerRadius);
        fContentPane.setPreferredSize(new Dimension(style.getWidth(), 100));
        this.getContentPane().add(fContentPane);
        JLabel fIconLabel = icon != null ? new JLabel(icon) : new JLabel("");
        fContentPane.add((Component)fIconLabel, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 11, 0, fIconInsets, 0, 0));
        if (title == null) {
            throw new RuntimeException("Title can not be empty!");
        }
        JTextArea fTitleLabel = this.getTextAreaForDisplay(title);
        fTitleLabel.setForeground(style.getTitleFontColor());
        fTitleLabel.setFont(style.getTitleFont());
        fContentPane.add((Component)fTitleLabel, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, fTitleLabelInsets, 0, 0));
        if (message != null) {
            fMessageLabel = this.getTextAreaForDisplay(message);
            fMessageLabel.setForeground(style.getMessageFontColor());
            fMessageLabel.setFont(style.getMessageFont());
            fContentPane.add((Component)fMessageLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, fMessageLabelInsets, 0, 0));
        } else {
            fMessageLabel = null;
        }
        this.pack();
        int titlePreferredHeight = TextUtil.calculatePreferredHeight(fTitleLabel.getFontMetrics(fTitleLabel.getFont()), fTitleLabel.getWidth() - fTitleLabelInsets.left - fTitleLabelInsets.right, title);
        fTitleLabel.setPreferredSize(new Dimension(fTitleLabel.getWidth(), titlePreferredHeight));
        int messagePreferredHeight = 0;
        if (message != null) {
            messagePreferredHeight = TextUtil.calculatePreferredHeight(fMessageLabel.getFontMetrics(fMessageLabel.getFont()), fMessageLabel.getWidth() - fMessageLabelInsets.left - fMessageLabelInsets.right, message);
            fMessageLabel.setPreferredSize(new Dimension(fMessageLabel.getWidth(), messagePreferredHeight));
        }
        if ((preferredHeight = titlePreferredHeight + messagePreferredHeight + fTitleLabelInsets.top + fTitleLabelInsets.bottom + fMessageLabelInsets.top + fMessageLabelInsets.bottom) < (iconHeight = fIconLabel.getHeight() + fIconInsets.top + fIconInsets.bottom)) {
            preferredHeight = iconHeight;
        }
        this.setPreferredSize(new Dimension(this.getPreferredSize().width, preferredHeight));
        this.pack();
    }

    private JTextArea getTextAreaForDisplay(String text) {
        JTextArea ta = new JTextArea(text);
        ta.setUI(new BasicTextAreaUI());
        ta.setEditable(false);
        ta.setFocusable(false);
        ta.setOpaque(false);
        ta.setWrapStyleWord(true);
        ta.setLineWrap(true);
        return ta;
    }
}

