/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.twinkle.style.overlay;

import ch.swingfx.twinkle.style.overlay.IOverlay;
import ch.swingfx.twinkle.style.overlay.OverlayPaintMode;
import java.awt.Graphics;

public abstract class AbstractOverlay
implements IOverlay {
    private final IOverlay fDecorator;
    private OverlayPaintMode fPaintMode;

    public AbstractOverlay(OverlayPaintMode paintMode, IOverlay decorator) {
        this.fDecorator = decorator;
        this.fPaintMode = paintMode;
    }

    @Override
    public void paintOverlayMouseOver(Graphics g, int cornerRadius) {
        switch (this.fPaintMode) {
            case ALWAYS: 
            case MOUSE_OVER: {
                this.paintMouseOver(g, cornerRadius);
            }
        }
        this.fDecorator.paintOverlayMouseOver(g, cornerRadius);
    }

    @Override
    public void paintOverlayMouseOut(Graphics g, int cornerRadius) {
        switch (this.fPaintMode) {
            case ALWAYS: 
            case MOUSE_OUT: {
                this.paintMouseOut(g, cornerRadius);
            }
        }
        this.fDecorator.paintOverlayMouseOut(g, cornerRadius);
    }

    @Override
    public void setOverlayPaintMode(OverlayPaintMode paintMode) {
        this.fPaintMode = paintMode;
        this.fDecorator.setOverlayPaintMode(paintMode);
    }

    public abstract void paintMouseOver(Graphics var1, int var2);

    public abstract void paintMouseOut(Graphics var1, int var2);
}

