/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.text;

import java.awt.FontMetrics;
import java.text.BreakIterator;

public final class TextUtil {
    private TextUtil() {
    }

    public static int calculatePreferredHeight(FontMetrics fm, int maxWidth, String text) {
        if ("".equals(text)) {
            return 0;
        }
        BreakIterator bi = BreakIterator.getLineInstance();
        bi.setText(text);
        int lineCount = 0;
        int lineHeight = fm.getHeight();
        int startOffset = bi.first();
        int endOffset = bi.next();
        do {
            String substring;
            int stringWidth;
            if (endOffset == text.length()) {
                --endOffset;
            }
            if ((stringWidth = fm.stringWidth(substring = text.substring(startOffset, endOffset))) <= maxWidth) continue;
            int toAdd = (int)(Math.ceil((double)stringWidth / (double)maxWidth) - 1.0);
            lineCount += toAdd;
            startOffset = bi.preceding(endOffset);
            bi.next();
        } while ((endOffset = bi.next()) != -1);
        return lineHeight * ++lineCount;
    }
}

