/*
 * Decompiled with CFR 0.152.
 */
package ch.swingfx.awt;

import java.awt.Insets;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class GraphicsEnvironmentUtil {
    public static final Insets OSX_MENU_BAR_SCREEN_INSETS = new Insets(22, 0, 0, 0);
    public static final boolean isX11GraphicsEnvironment;
    public static final boolean isCGraphicsEnvironment;
    public static final boolean isWin32GraphicsEnvironment;

    static {
        String graphicsEnv = System.getProperty("java.awt.graphicsenv");
        isWin32GraphicsEnvironment = "sun.awt.Win32GraphicsEnvironment".equals(graphicsEnv);
        isX11GraphicsEnvironment = "sun.awt.X11GraphicsEnvironment".equals(graphicsEnv);
        isCGraphicsEnvironment = "apple.awt.CGraphicsEnvironment".equals(graphicsEnv);
    }

    private GraphicsEnvironmentUtil() {
    }

    public static Rectangle getX11RootNetWorkarea() {
        ProcessBuilder pc = new ProcessBuilder("xprop", "-root", "-notype", "_NET_WORKAREA");
        try {
            Process process = pc.start();
            InputStream inputStream = process.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader reader = new BufferedReader(inputStreamReader);
            String line = reader.readLine();
            process.waitFor();
            reader.close();
            String[] windowProperties = line.split("=")[1].trim().split(",");
            int x = Integer.parseInt(windowProperties[0].trim());
            int y = Integer.parseInt(windowProperties[1].trim());
            int width = Integer.parseInt(windowProperties[2].trim());
            int height = Integer.parseInt(windowProperties[3].trim());
            return new Rectangle(x, y, width, height);
        }
        catch (Exception e) {
            return null;
        }
    }
}

