/**
 * PAUL HUSSMAN
 * 260224172
 * COMP 409
 * ASSIGNMENT 3
 * QUESTION 2
 */



public class FloorPlan {
	
	// 2D array of integers representing the grid
	private GridSpace[][] grid;
	
	// flag for activity (true by default)
	private boolean active = true;
	
	// constructor taking in the length of one side of the square
	public FloorPlan(int x){
		grid = new GridSpace[x][x];
		// fill entire grid with 0's
		for (int i = 0; i < grid.length; i++){
			for (int j = 0; j < grid.length; j++){
				grid[i][j] = new GridSpace(i, j);
			}
			
		}
	}
	
	
	public int size(){
		return grid.length;
	}
	
	// returns a particular grid space in the floor plan
	public GridSpace getGridSpace(int x, int y){
		return grid[x][y];
	}
	
	// returns true if a cell is occupied and false otherwise
	public boolean isOccupied(int x, int y){
		if(x<0 || y<0){
			return true;
		}
		return grid[x][y].character != null;
	}
	
	// sets a cell as occupied
	public void setOccupied(Character c, int x, int y){
		grid[x][y].character = c;
	}
	
	// sets a cell as vacant
	public void setVacant(int x, int y){
		grid[x][y].character = null;
		grid[x][y].isObstacle = false;
	}
	
	// returns true if input position is vacant
	public boolean isVacant(int x, int y){
		return grid[x][y].character == null && !grid[x][y].isObstacle;
	}
	
	// creates an obstacle at specified coordinates
	public void createObstacle(int x, int y){
		grid[x][y].isObstacle = true;
	}
	
	// returns true if there is an obstacle at specified coordinates, and false otherwise
	public boolean detectObstacle(int x, int y){
		// return false for out of bounds
		if(x<0 || x > grid.length-1 || y<0 || y > grid.length-1){
			return false;
		}
		
		return grid[x][y].isObstacle;
	}
	
	public boolean isObstacle(int x, int y){
		return grid[x][y].isObstacle;
	}

	// determines whether this floor plan is active
	public boolean isActive() {
		return active;
	}
	
	public void setInactive(){
		active = false;
	}
/*	
	// sets a value in the grid
	public void setValue(int x, int y, int v){
		grid[x][y] = v;
	}
	
	// returns a copy of this floor plan
	public FloorPlan copy(){
		return new FloorPlan(grid);
	}
*/
	
	
	
}
