/**
 * PAUL HUSSMAN
 * 260224172
 * COMP 409
 * ASSIGNMENT 3
 * QUESTION 2
 */

import java.util.ArrayList;
import java.util.Random;

public class Main {
	
	public static ArrayList<Character> characterList = new ArrayList<Character>();
	public static ArrayList<Thread> threadList = new ArrayList<Thread>();
	public static FloorPlan map;
	
	public static void main(String[] args){
		try {
			// restrict input to appropriate values
			if (args.length != 3 || Integer.parseInt(args[0]) < 1 || Integer.parseInt(args[1]) < 5 || Integer.parseInt(args[2]) < 1 || Integer.parseInt(args[2]) > 3 ){
				System.err.println("Usage: java Main n m k\n n is the number of characters\n m is the square grid dimension\n k = {1, 2, or 3} is the choice of floor-plan");
				return;
			}
		} catch (NumberFormatException nfe) {
			System.err.println("Usage: java Main n m k\n n is the number of characters\n m is the square grid dimension\n k = {1, 2, or 3} is the choice of floor-plan");
			return;
		}
		
		// paramaters
		final int N = new Integer(args[0]);	// number of Characters
		final int M = new Integer(args[1]);	// grid size (at least 5)
		final int K = new Integer(args[2]);	// map number
		
		// number of random objects for map 2 (don't make this larger than the number of obstacles in the spiral)
		int R = 120;

		if (R > Math.pow(M-4,2)){
			System.err.println("r is too big for specified m.  will use r = 1");
			R = 1;
		}
	
		
		// create map of size m x m (at least 5 x 5)
		map = new FloorPlan(M);
		System.out.println("Map created");
		
		// if K == 1, do not create any obstacles
		
		// add obstacles according to k-value
		if (K == 2){
			// create random obstacle pattern
			makeRandomObstacles(map, R, M);
			System.out.println("r random obstacles were made");
			
		} else if (K == 3){
			// create spiral obstacle pattern
			makeSpiral(map, R, M);
			System.out.println("gapped spiral was made");
		} 
		
		// add characters to the character list
		// at (somewhat) evenly distributed places around map perimeter
		createCharacters(map, N, M);
		System.out.println("characters created");
		
		// create and keep track of threads for each character
		for (Character c : characterList){
			threadList.add(new Thread(c));
		}
		
		// start all threads
		for (Thread t : threadList){
			t.start();
		}
		System.out.println("Running... \nPlease wait for results...");
		// join all threads before final output
		for (Thread t : threadList){
			try {t.join(); } catch (InterruptedException e) {}
		}
		
		// print out number of moves for each character
		System.out.println("Done.\n Results:");
		int i = 1;
		for (Character c : characterList){
			System.out.println("   Character "+i+": "+c.moveCount);
			i++;
		}
		

	}
	
	// draws a spiral of obstacles and then randomly deletes R of them
	private static void makeSpiral(FloorPlan map, int r, int m){
		Random generator = new Random();
		
		// starting position
		int x = m/2;
		int y = m/2;
		
		int count = 1;
		int stop = m-4;
		boolean up    = false;
		boolean down  = false;
		boolean left  = false;
		boolean right = true;
		

		
		map.createObstacle(x, y); //create center obstacle
		
		// draw outward spiral until the next coordinate lies on the perimeter
		while (count <= stop){
			// turn left
			if      (up)   {up = false; left = true;}
			else if (left) {left = false; down = true;}
			else if (down) {down = false; right = true;}
			else if (right){right = false; up = true;}
			//else {System.out.println("here");}
			
			// create 'count' obstacles in a line of current direction
			for (int i = 0; i < count; i++){
				if (up){
					y++;
				}else if(down){
					y--;
				}else if (left){
					x--;
				}else if (right){
					x++;
				}
				map.createObstacle(x, y);
			}
			// make the next line of obstacles one character longer
			count ++;
		}
		

		// Put r random gaps into the spiral
		for (int i = 0; i < r; i++){	// do the following procedure 'r' times:
			// go through random coordinates until an obstacle is found
			do {
				x = generator.nextInt(m);
				y = generator.nextInt(m);
			} while(!map.isObstacle(x, y));
			
			// remove the obstacle
			map.setVacant(x, y);
		}
		
		
	}
	
	// creates 'r' random obstacles on given FloorPlan of dimensions m x m.
	// never creates obstacles within 2 grid spaces of the perimeter
	public static void makeRandomObstacles(FloorPlan map, int r, int m){
		Random generator = new Random();
		int newX = -1;
		int newY = -1;
		for(int i = 0; i < r; i++){
			// prevents putting two obstacles in the same spot
			while(map.isOccupied(newX, newY)){
				// keeps obstacles away from edges
				newX = generator.nextInt(m-4)+2;
				newY = generator.nextInt(m-4)+2;
			}
			map.createObstacle(newX, newY);
		}
	}
	

	// plots characters in their initial positions along the perimeter
	private static void createCharacters(FloorPlan map, int n, int m) {
		Random generator = new Random();
		double randomNumber;
		int[] nextSpot = new int[2];
		
		for (int i = 0; i < n; i++){
			// repeat the following procedure until a free spot is found
			do {
				randomNumber = Math.random();
				// randomly choose a side
				if (randomNumber < .25){
					nextSpot[0] = 0;
					nextSpot[1] = generator.nextInt(m);
				} else if (randomNumber >= .25 && randomNumber < 0.5) {
					nextSpot[0] = generator.nextInt(m);
					nextSpot[1] = 0;
				} else if (randomNumber >= .5 && randomNumber < 0.75) {
					nextSpot[0] = m-1;
					nextSpot[1] = generator.nextInt(m);
				} else if (randomNumber >= .75) {
					nextSpot[0] = generator.nextInt(m);
					nextSpot[1] = m-1;
				}
			} while (!map.isVacant(nextSpot[0], nextSpot[1]));
			
			// create a character at that next spot
			characterList.add(new Character(map, nextSpot[0], nextSpot[1]));
			map.setOccupied(characterList.get(characterList.size()-1),nextSpot[0], nextSpot[1]);
		}
	}
}
