/**
 * PAUL HUSSMAN
 * 260224172
 * COMP 409
 * ASSIGNMENT 3
 * QUESTION 2
 * 
 */
import java.util.Random;

// WHY IT DOESN'T DEADLOCK:
/*
  NOTE  - 	DOESN'T DEADLOCK BECAUSE THERE WILL ALWAYS BE AT LEAST ONE SPACE THAT
 			CAN BE REACHED BY ONE CHARACTER WHILE THE OTHER ONES MIGHT HAVE TO 
			CONTINUOUSLY RECALCULATE A ROUTE UNTIL ONE WORKS.
			ONCE THAT ONE IS OUT OF THE WAY, A SPACE FREES UP FOR ANOTHER ONE, etc.
			SINCE LOCKS ARE AQUIRED IN A DEFINED FASHION, THIS SITUATION WILL NEVER
			RESULT IN DEADLOCK
*/



public class Character implements Runnable {
	
	private static final int SUCCESS_MAX = 2;	// stop after 10 successes
	private int xPosition;
	private int yPosition;
	private FloorPlan floorPlan;
	private int[] targetSpot;
	public int moveCount = 0;
	public int successCount = 0;
	
	// create a character at a particular position
	public Character(FloorPlan fp, int x, int y){
		xPosition = x;
		yPosition = y;
		floorPlan = fp;
		fp.setOccupied(this, x, y);
		targetSpot = getRandomXY(fp.size());
	}
	
	// the run method for a character
	public void run(){
		int loopCount = 0;	// counts 20ms time intervals
		int[][] planner = planRoute();	// 2D array used to plan route initialized to random destination
		
		// repeat the following algorithm until done or until a problem occurs

		
		boolean blocked = false;	// flag to determine if the pathway is blocked by another character
		Direction nextDirection;
		
		// repeat the following while the floor plan is active
		while (floorPlan.isActive()){
				
			// find next direction based on lee's algorithm
			nextDirection = getNextDirection(planner, floorPlan.size() + 1);
			
			if (nextDirection == null) {
				blocked = true;//cant move
			} else {
				// lock next position
				synchronized(floorPlan.getGridSpace(xPosition+nextX(nextDirection), yPosition+nextY(nextDirection))){
					
					// check that this character is not blocked
					if (canMove(nextDirection)){
						// lock this character for move procedure
						synchronized (this){
							// perform next move
							moveOne(nextDirection);
							moveCount ++;
							System.out.println("moved");
							// report bad behavior and break this character
							if(xPosition < 0 || xPosition > floorPlan.size()-1 || yPosition < 0 || yPosition > floorPlan.size()-1){
								System.err.println("PROBLEM! character moved out of bounds.  Simulation aborted");
								floorPlan.setInactive();
							}
						}
					
					} else {
						// flag pathway as blocked
						blocked = true;
						//System.out.println("blocked");
					}
				}
			}
			
		//	System.out.println("Target: " + targetSpot[0] + ", "+ targetSpot[1]);
		//	System.out.println("Current: "+xPosition + ", " + yPosition);
			
			// if target is reached or if path was blocked by another character
			if (blocked){
				// plan a new route to a new random destination
				planner = planRoute();
				
			} else if (xPosition == targetSpot[0] && yPosition == targetSpot[1]){
				successCount ++;
				planner = planRoute();
			}
			
		
			
			// sleep for 20ms granularity
			try { Thread.sleep(20); } catch (InterruptedException e) {}
		

			loopCount ++;
			
			// stop run method
			if (successCount >= SUCCESS_MAX){
				floorPlan.setInactive();
			}
			
		}//end big while loop
		
		
	}// end run method
	
	private Direction getNextDirection(int[][] planner, int smallestValue) {
		Direction nextDirection = null;
		if (canMove(Direction.UP)){
			smallestValue = planner[xPosition][yPosition+1];
			nextDirection = Direction.UP;
		}
		
		if (canMove(Direction.RIGHT)){
			if(planner[xPosition+1][yPosition] < smallestValue){
				smallestValue = planner[xPosition+1][yPosition];
				nextDirection = Direction.RIGHT;
			}
		}
		if(canMove(Direction.DOWN)){
			if(planner[xPosition][yPosition-1] < smallestValue){
				smallestValue = planner[xPosition][yPosition-1];
				nextDirection = Direction.DOWN;
			}
		}
		
		if (canMove(Direction.LEFT)){
			if(planner[xPosition-1][yPosition] < smallestValue){
				smallestValue = planner[xPosition-1][yPosition];
				nextDirection = Direction.LEFT;
			}
		}
		return nextDirection;
	}

	// returns true if there is nothing in the way
	private boolean canMove(Direction nextDirection) {
		boolean canMove = false;
		try {
			if (floorPlan.isVacant(xPosition + nextX(nextDirection), yPosition + nextY(nextDirection))){
				canMove = true;
			}
		} catch (ArrayIndexOutOfBoundsException e){}
		
		return canMove;
	}


	
	// atomically move one cell in a specified direction - (UP, DOWN, LEFT or RIGHT)
	public void moveOne(Direction d){

		// adjust coordinates for whichever direction it's moving
		// also adjust the floor plan accordingly
		if        (d == Direction.UP){
			floorPlan.setVacant(xPosition, yPosition);
			yPosition++;
			floorPlan.setOccupied(this, xPosition, yPosition);
		} else if (d == Direction.DOWN){
			floorPlan.setVacant(xPosition, yPosition);
			yPosition--;
			floorPlan.setOccupied(this, xPosition, yPosition);
		} else if (d == Direction.LEFT){
			floorPlan.setVacant(xPosition, yPosition);
			xPosition--;
			floorPlan.setOccupied(this, xPosition, yPosition);
		} else if (d == Direction.RIGHT){
			floorPlan.setVacant(xPosition, yPosition);
			xPosition++;
			floorPlan.setOccupied(this, xPosition, yPosition);
		}
		
	}
	
	
	// add return value of this method to xCoordinate to determine the next xCoordinate based on a direction
	public int nextX(Direction d){
		if ( d == Direction.LEFT){
			return -1;
		} else if (d == Direction.RIGHT){
			return 1;
		} else {
			return 0;
		}
	}
	// add return value of this method to yCoordinate to determine the next yCoordinate based on a direction
	public int nextY(Direction d){
		if ( d == Direction.DOWN){
			return -1;
		} else if (d == Direction.UP){
			return 1;
		} else {
			return 0;
		}
	}
	
	// returns an array of two random coordinates, each from 0 to m-1
	public int[] getRandomXY(int m){
		Random generator = new Random();
		int x = generator.nextInt(m);
		int y = generator.nextInt(m);
		return new int[]{x,y};
	}
	
	
	
	// plans a route for this character to follow towards a randomly selected target
	public int[][] planRoute(){
		
		// grid to keep track of planned route
		int[][] planner = new int[floorPlan.size()][floorPlan.size()];
		int position;
		
		// get new destination that's not occupied by an obstacle
		while (floorPlan.detectObstacle(targetSpot[0], targetSpot[1])){
			targetSpot = getRandomXY(floorPlan.size());
		}
		
		// calculate path (Lee's Algorithm http://en.wikipedia.org/wiki/Lee_algorithm)
		// 1) initialization		
		for (int i = 0; i < planner.length; i++){
			for (int j = 0; j < planner[0].length; j++){
				planner[i][j] = floorPlan.size()+1;
			}
		}
		
		planner[xPosition][yPosition] = 0;
		
		position = 0;
		
		// 2) Wave Expansion
		boolean targetReached = false;
		boolean atLeastOneFound = false;
		do {
			for (int i = 0; i < planner.length; i++){
				for (int j = 0; j < planner[0].length; j++){
					 atLeastOneFound = false;
					if (planner[i][j] == position){
						// look up, down, left and right for unlabelled positions and label with with position+1
						try{
							if(planner[i][j+1]==floorPlan.size()+1 && !floorPlan.detectObstacle(i, j+1)){
								planner[i][j+1] = position + 1;
								atLeastOneFound = true;
							}
						} catch (ArrayIndexOutOfBoundsException e){}
						try{
							if(planner[i][j-1]==floorPlan.size()+1 && !floorPlan.detectObstacle(i, j-1)){
								planner[i][j-1] = position + 1;
								atLeastOneFound = true;
							}
						} catch (ArrayIndexOutOfBoundsException e){}
						
						try{
							if(planner[i+1][j]==floorPlan.size()+1 && !floorPlan.detectObstacle(i+1, j)){
								planner[i+1][j] = position + 1;
								atLeastOneFound = true;
							}
						} catch (ArrayIndexOutOfBoundsException e){}
							
						try{
							if(planner[i-1][j]==floorPlan.size()+1 && !floorPlan.detectObstacle(i-1, j)){
								planner[i-1][j] = position + 1;
								atLeastOneFound = true;
							}
						} catch  (ArrayIndexOutOfBoundsException e){}
						
					}
				}
			}
			position++;
		}while(!targetReached && atLeastOneFound);
		return planner;
	}
	
	
}
