//////////////////////////////////////////
//                                     //
//     COMP 310 - OPERATING SYSTEMS    //
//     Assignment 4 - Part 1           //
//     Alexander Kawrykow              //
//     260324367                       //
//     Michael Shapiro		       //
//     260261525                       //
//                                     //
/////////////////////////////////////////

#ifndef OS_INCL
#define OS_INCL 1
#include "OS.h"
#endif

//create a new node and return a pointer
node *newNode(char *v, char *val){
	node* new = (node* )malloc(sizeof(node));
	
	//not enough space 
	if (new == NULL){
		printf("Error: not enough memory. Free up some space first.\n");
	} else {
		strcpy(new->var, v);
		strcpy(new->value, val);
		new->next = NULL;
	}

	return new;
}

//add given node to given linked list 
void addNode(linkedlist* list, node* e){
	node* cur = list;

	//was the first node added to the list 
	if ((strcmp(cur->var, "")) == 0){
		strcpy(cur->var, e->var);
		strcpy(cur->value, e->value);

	// otherwise look for space 
	} else {
		int found = 0;
		while (cur->next){
			
			//found an existing node with same variable
			//so over-write
			if ((strcmp(cur->var, e->var)) == 0){
				strcpy(cur->value, e->value);
				found = 1;
				break;
			} else {
				cur = cur->next;
			}
		}

		if (!found){

			if ((strcmp(cur->var, e->var)) == 0){
				strcpy(cur->value, e->value);

			//new variable so append to list
			} else {
				cur->next = e;
				e->next = NULL;
			}
		}
	}

}

//return node with given variable name
node *findNode(linkedlist* list, char* v){
	node* cur = list;
	while (cur){
		if ((strcmp(cur->var, v)) == 0){
			return cur;
		} else {
			cur = cur->next;
		}
	}
	return NULL;
}

//print a (VAR, VALUE) pair 
void printNode(node *n){
	printf("%s = %s\n", n->var, n->value);
}

//print the contents of shell memory
void printList(linkedlist *list){
	node *cur = list;
	while (cur){
		printNode(cur);	
		cur = cur->next;
	}
} 

//<--------MYSH FUNCTION--------->//

//check an arg for validity 
//returns 1 for valid, 0 for invalid 
int validArg(char *arg){

	int f;
	int s;
	char x[MAX_INPUT];

	if ((strcmp(arg, "-v")) == 0){
		return 1;
	} else if ((strcmp(arg, "-V")) == 0){
		return 1;
	} else if ((strcmp(arg, "-h")) == 0){
		return 1;
	} else if ((strcmp(arg, "-H")) == 0){
		return 1;
	} else if ((sscanf(arg, "-f:%d", &f)) == 1 && (sprintf(x, "%d", f) == strlen(arg)-3)){
		return 1;
	} else if ((sscanf(arg, "-framesize:%d", &s)) == 1 && (sprintf(x, "%d", s) == strlen(arg)-11)){
		return 1;
	} else {
		return 0;
	}
}

int initMysh(int argc, char *argv[]){
	int eCode = 0;
	int vMode = 0;
	char *help = "-v : Puts the shell in verbose mode.\n--Displays extra information explaining what to do in each situation.\n--Will prompt user for confirmation before any command is executed.\n\n-h : Will not run the shell but simply display this help screen. \n--myOs will then terminate.\n\n-f:NUM : limit RAM space available\n--Only allow NUM bytes for program storage\n--NUM must be > 0 and < 990\n";

	//check for correct number of arguments
	if (argc >= 1 && argc <= 4){
		int i = 1;

		//go through arguments
		while (i < argc){
			
			//unknown argument 
			if (!validArg(argv[i])){
				printf("Unknown argument %s. Usage: \n\n%s", argv[i], help);
				eCode = 1;
				break;
			} else {	
				//found -h, so show help and quit 
				if ((strcmp(argv[i], "-h")) == 0 || (strcmp(argv[i], "-H") == 0)){
					printf("%s", help);
				//found -v so turn verbose on 
				} else if ((strcmp(argv[i], "-v")) == 0 || (strcmp(argv[i], "-V")) == 0){
					vMode = 1;
				}
			}	
			i++;
		}		
	} else {
		printf("Incorrect number of arguments. Usage: \n\n%s", help);
		eCode = 1;
	}


	//everything went smoothly, so define shell memory 
	if (!eCode){

		//create the shell memory linked list
		//Begin by creating a blank head 
		shellMemory = newNode("", ""); 

		//add verbose variable to shell memory
		addNode(shellMemory, newNode("VERBOSE", (vMode == 1 ? "ON" : "OFF")));

		//add the prompt string to shell memory
		node* prompt = newNode("PROMPT", ":D ");
		addNode(shellMemory, prompt);
	}

	return eCode;
}

//return 1 if a string is just white space 

int whiteSpace(char* str){
	while (*str){
		if (*str != ' ' || *str != '	') {return 0;}
		str++;
	}
	return 1;
}

int mysh(){
	if (((strcmp((findNode(shellMemory, "VERBOSE"))->value, "ON")) == 0 ? 1 : 0)) printf("Please enter a command: ");
			
	//print appropriate prompt string 
	node* prompt = findNode(shellMemory, "PROMPT");
	printf("%s", prompt->value);

	//get command and execute
	char command[MAX_INPUT];
	fgets(command, MAX_INPUT, stdin);
	char *c;
	if ((c = strtok(command, "\n")) != NULL && !whiteSpace(c)){
		return interpreter(c, NULL);	//run command in shell memory environment 
	}
	return 0;
}

//debugging function to print contents of a PCB's heap
void printHeap(char *memory[], int size){
	int i = 0;
	while (i < size){
		if (memory[i] != NULL && (strcmp(memory[i], "")) != 0) printf("%d) %s\n", i, memory[i]);
		i++;
	}
}		

//execute the given command.
int interpreter(char copy[], char *memory[]){ 
	char command[MAX_INPUT];
	strcpy(command, copy);
	char c[MAX_INPUT];
	int status = 0;
	
	//determine whether verbose mode is on from either shell memory or heap
	//if a process is running, commands should not be run in verbose mode
	int vMode = ((strcmp((findNode(shellMemory, "VERBOSE"))->value, "ON")) == 0 && memory == NULL ? 1 : 0);

	//user entered EXIT
	if ((strcmp(command, "EXIT")) == 0){

		//if in verbose mode, confirm
		if (vMode){
			printf("Are you sure you want to exit? ");
			fgets(c, MAX_INPUT, stdin);
			char *x = strtok(c, "\n");
			if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
				return status;
			}
		}

		//quit
		status = -1;

	//user entered LOGOUT
	} else if ((strcmp(command, "LOGOUT")) == 0){

		//if in verbose mode, confirm
		if (vMode){
			printf("Are you sure you want to logout? ");
			fgets(c, MAX_INPUT, stdin);
			char *x = strtok(c, "\n");
			if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
				return status;
			}
		}

		//logout
		status = -1;

	//user entered VER
	} else if ((strcmp(command, "VER")) == 0){
		
		//display author etc
		printf("mySh v 1.0alpha - Written by Alexander Kawrykow (01/25/2010)\n\n");

	//user entered CLR
	} else if ((strcmp(command, "CLR")) == 0){

		//if in verbose mode, confirm 
		if (vMode){
			printf("Are you sure you want to clear the screen? "); 
			fgets(c, MAX_INPUT, stdin);
			char *x = strtok(c, "\n");
			if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
				return status;
			}
		}


		//'clear' the screen by printing 100 blank lines
		int i = 0;
		for (i = 0; i < 100; i++){
			printf("\n");
		}

	//user entered HELP
	} else if ((strcmp(command, "HELP")) == 0){

		//display the help contents
		printf("mySh - Help Contents: \n======================\nEXIT - cause mySh to exit\nVER - displays information about mySh\nCLR - 'Clears' the screen\nHELP - Brings up this help menu.\nPROMPT VALUE - Changes the prompt string to VALUE\nVERBOSE VALUE - Changes verbose mode. VALUE is either ON or OFF\nSET VAR VALUE - puts VALUE into shell memory under VAR\nGET VAR - displays the value for the given VAR\nSCRIPT FILENAME - Executes the script at location FILENAME\n");
	
	//print contents of shell memory (for debugging purposes)
	} else if ((strcmp(command, "PRINT")) == 0){
		printList(shellMemory);
	//print contents of ram and queues(for debugging purposes)
	} else if ((strcmp(command, "INFO")) == 0){
		printf("\nQUEUES\n============\nloading queue: ");
		printQueue(loadingHead);
		printf("\nready queue: ");
		printQueue(readyHead);
		printf("\nwaiting queue: ");
		printQueue(waitingHead);
		printf("\nterminating queue:\n");
		printQueue(terminatingHead);
		printf("\n\nRAM\n========================================\n");
		printHeap(RAM, RAM_MAX);
		printf("========================================\n\n");
	//was potentially a multi-word command
	} else {

		char *split[10];
		char *delims = " ";
		int i = 1;

		//tokenize the input 
		split[0] = strtok(command, delims);
		while ((split[i] = strtok(NULL, delims)) != NULL){
			i++;
		}

		//change the prompt 
		if ((strcmp(split[0], "PROMPT")) == 0){		

			//check for correct input 
			if (split[1] != NULL){

				//if in verbose mode, confirm 
				if (vMode){
					printf("Are you sure you want to change the prompt? "); 
					fgets(c, MAX_INPUT, stdin);
					char *x = strtok(c, "\n");
					if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
						return status;
					}
				}
				
				//will update the shell memory input for PROMPT
				node *newPrompt = newNode("PROMPT", split[1]);
				addNode(shellMemory, newPrompt);

			} else {
				printf("Incorrectly formatted PROMPT string.\n");
				return status;
			}

		//return a shell memory variable 
		} else if ((strcmp(split[0], "GET")) == 0){

			//check for correct input
			if (split[1] != NULL){

				//search in shell memory
				if (memory == NULL){
					node *var = findNode(shellMemory, split[1]);
					if (var == NULL){
						printf("%s is not defined.\n ", split[1]);
					} else {
						printNode(var);
					}
				//search in the heap
				} else {
					int j;
					for (j = 0; j < HEAP_SIZE; j++){
						//make a copy of the line of memory because for some strange reason,
						//tokenizing it screws it up
						char copy[MAX_INPUT];
						strcpy(copy, memory[j]);
						char *s = strtok(memory[j], "=");
						if ((strcmp(s, split[1])) == 0){
							printf("%s = %s\n", s, strtok(NULL, "="));	//found a match 
							strcpy(memory[j], copy);			//copy the line back cuz it got damaged for some strange reason
							return status;
						}
					}
					printf("%s is not defined.\n", split[1]);
					return status;
				}
			} else {

				printf("Please input a variable to lookup.\n");
				return status;

			}

		//set a shell memory variable 
		} else if ((strcmp(split[0], "SET")) == 0){

			if (split[1] != NULL && split[2] != NULL){

				//if in verbose mode, confirm
				if (vMode){
					printf("Are you sure you want to set this variable? ");
					fgets(c, MAX_INPUT, stdin);
					char *x = strtok(c, "\n");
					if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
						return status;
					}
				}
				
				//set variable in shell memory
				if (memory == NULL){
					node *var = newNode(split[1], split[2]);
					addNode(shellMemory, var);
				//set veriable in processes' heap space
				} else {
					//format the string into VAR=VALUE
					int a = strlen(split[1]) + strlen(split[2]) + 1;
					char merge[a];
					strcpy(merge, split[1]);
					strcat(merge, "=");
					strcat(merge, split[2]);
					a = 0;

					//find first free spot in heap space and write 
					while (a < HEAP_SIZE){
						//make a copy of the line of memory because for some strange reason,
						//tokenizing it screws it up
						char copy[MAX_INPUT];
						strcpy(copy, memory[a]);
						char *s = strtok(copy, "=");
						if (s != NULL){
							if (strcmp(s, "") == 0 || strcmp(s, split[1]) == 0) break;
						} else {
							break;
						}
						a++;
					}

					//write variable to HEAP space 
					if (a < HEAP_SIZE){ 
						strcpy(memory[a], merge);
					} else {
						printf("Error. Memory is full.\n");
					}
				}
			} else {
				printf("command was %s\n", command);
				printf("Usage: SET VAR VALUE\n--VAR: name of the variable to set.\n--VALUE: value attributed to VAR\n");
				return status;

			}

		//change verbose mode setting
		//(NOTE: IDENTICAL TO SET VERBOSE ON or SET VERBOSE OFF) 
		} else if ((strcmp(split[0], "VERBOSE")) == 0){

			if (split[1] != NULL){

				//if in verbose mode, confirm
				if (vMode){
					printf("Are you sure you want to change your verbose mode settings? ");
					fgets(c, MAX_INPUT, stdin);
					char *x = strtok(c, "\n");
					if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
						return status;
					}
				}

				if ((strcmp(split[1], "ON")) == 0 || (strcmp(split[1], "OFF")) == 0){
					node* v = newNode("VERBOSE", split[1]);
					addNode(shellMemory, v);
				} else {
					printf("Usage: VERBOSE V\n--V: must either be ON or OFF\n");
					return status;
				}
			} else {
				printf("Usage: VERBOSE V\n--V: must either be ON or OFF\n");
				return status;
			}
		//echo a statement
		} else if ((strcmp(split[0], "ECHO")) == 0){
			int j = 1;
			while (split[j] != NULL){
				printf("%s ", split[j]);
				j++;
			}
			printf("\n"); 

		//run a process 
		} else if ((strcmp(split[0], "RUN")) == 0){
			
			int k = 1;
			int s;
			char* l;

			//loop through each entered filename 
			while (split[k] != NULL){
				FILE *tmp = fopen(split[k], "rt");
				if (tmp == NULL){
					printf("Could not locate file %s.\n", split[k]);
					return 1;	//error opening file 
				} else {					
					
					//make the new filename
					char newName[MAX_INPUT];
					strcpy(newName, "./BACKINGSTORE/");
					strcat(newName, split[k]);
					strcat(newName, ".BS");
					FILE* bsWrite = fopen(newName, "wt");
					if (bsWrite == NULL){
						printf("Error writing to file..\n");
						fclose(tmp);
						return 1;
					}

					//go through the lines and copy into the struct
					char line[MAX_INPUT];
					struct bs_rec* newScript = newBS();
					int i = 0;
					int j = 0;
					int p = 0;
					while ((fgets(line, MAX_INPUT, tmp)) != NULL){
						l = strtok(line, "\n");
						if (l != NULL){
							j++;
							strcpy(newScript->command[i], l);
							if (i < 3){
								i++;
							} else {
								fwrite(newScript, sizeof(struct bs_rec), 1, bsWrite);
								i = 0;
								newScript = newBS();
								p++;
							}
						}
					}
					k++;

					//write last page, free struct
					if (j % 4 != 0){
						fwrite(newScript, sizeof(struct bs_rec), 1, bsWrite);
						p++;
					}

					free(newScript);					
					fclose(bsWrite);					
					fclose(tmp);

					//create the PCB and enqueue it 
					struct PCB* tempPCB = newPCB(split[k-1], 0, 0, j);
					FILE* bsRead = fopen(newName, "r");
					tempPCB->backingStore = bsRead;
					tempPCB->maxPages = p;
					tempPCB->id = processCount;
					processCount++;
					pushLoadingQueue(tempPCB);
					
				}		
			}		
				
		//execute a script 
		} else if ((strcmp(split[0], "SCRIPT")) == 0){

			//check for correct number of arguments
			if (split[1] != NULL){

				FILE *f = fopen(split[1], "rt");
				if (f == NULL){
					printf("Could not load file %s\n", split[1]);
				} else {

					//if verbose mode, confirm 
					if (vMode){
						printf("Are you sure you want to execute %s? ", split[1]);
						fgets(c, MAX_INPUT, stdin);
						char *x = strtok(c, "\n");
						if (x == NULL || strlen(x) > 2 || !((strcmp(x, "y")) == 0 || (strcmp(x, "Y")) == 0)){
							return status;
						}
					}

					//go through each line of the script and execute the command
					char line[MAX_INPUT];

					char check[MAX_INPUT] = "SCRIPT ";
					strcat(check, split[1]);
					
					while ((fgets(line, MAX_INPUT, f)) != NULL){

						char *l;
						l = strtok(line, "\n");
						if (l != NULL) status = interpreter(l, NULL);

					}

				}

			} else {
				printf("Please specify a filename for the script to read from.\n");
				return status;
			}

		//open a filename
		} else if ((strcmp(split[0], "OPEN")) == 0){

			//check for correct number of args
			if (split[1] == NULL || split[2] == NULL || split[3] == NULL){

				printf("Incorrect number of arguments.\n");
				return status;

			} else {

				//all arguments are well formed 
				int i = strlen(split[3]) == 1 ? *split[3] - '0' : -1;
				if ((strcmp(split[2], "AT")) == 0 && i >= 0 && i <= 4){
					
					//file is not currently in use 
					if (fileHandles[i][0] == -1){

						//PCB calling the OPEN command 
						if (memory != NULL){
							fileHandles[i][0] = running->id;

						//OPEN command being called in a shell environment 
						} else {

							fileHandles[i][0] = 0;

						}

						//search for offset from OSFAT table
						struct OSFAT * rec = (struct OSFAT*)malloc(sizeof(struct OSFAT));
						rewind(OSFATTable);

						int j;
						do {
							j = fread(rec, sizeof(struct OSFAT), 1, OSFATTable);
						} while (j && (strcmp(split[1], rec->filename) != 0));

						//file exists, so set the offset from OSFAT table 
						if (strcmp(split[1], rec->filename) == 0){
							
							fileHandles[i][1] = rec->address;
							fileHandles[i][2] = rec->address;

						} else {

							//create the file and update the OS FAT table
							rec = (struct OSFAT*)malloc(sizeof(struct OSFAT));
							strcpy(rec->filename, split[1]);
							rec->address = findHDSpace();

							if (rec->address == -1){
								if (memory != NULL){
									printf("Process ");
									printf("%s ", running->filename);
									printf("terminate. ");

									//terminate this pcb
									pushTerminateQueue(running); 
								}
								printf("No more disk space. \n");
								return status;
							}
							fwrite(rec, sizeof(struct OSFAT), 1, OSFATTable);
							fileHandles[i][1] = rec->address;
							fileHandles[i][2] = rec->address;

							//initialize first block for new file 
							fseek(hardDisk, rec->address, 0);
							for (j = 0; j < BLOCK_SIZE; j++){
								fputc('2', hardDisk);	//reserved space character
							}
						}
					} else {

						//put this process to sleep
						if (memory != NULL){
							if (running != NULL){
								running->requestId = i;
								pushWaitingQueue(running);
							}
						} else {
							printf("Error: index in use by another process. \n");
						}
					}

				} else {

					printf("Incorrect arguments.\n");

				}

			}
						
		//CLOSE A FILE
		} else if ((strcmp(split[0], "CLOSE")) == 0){

			if (split[1] == NULL){

				printf("incorrect number of arguments.\n");
				return status;

			} else {

				int i = strlen(split[1]) == 1 ? *split[1] - '0' : -1;
				if (i >= 0 && i <= 4){
		
					//check if file is even open
					if (fileHandles[i][0] != -1){

						//shell environment, so no conflict. just close the file
						 if ((memory == NULL && fileHandles[i][0] == 0) || (running != NULL && fileHandles[i][0] == running->id && memory != NULL)){
							fileHandles[i][0] = -1;
							fseek(hardDisk, fileHandles[i][1], 0);
							fputc('1', hardDisk);

						} else {
							printf("Trying to close an open file by a process id who does not own the handle.\n");
						}

					} else {
						printf("Trying to close a non-open file handle at index %d.\n", i);
					}

				} else {

					printf("Invalid argument.\n");
		
				}
			}
		//WRITE TO THE DISK
		} else if ((strcmp(split[0], "WRITE")) == 0){
			if (split[1] == NULL || split[2] == NULL){
				
				printf("incorrect number of arguments.\n");
		
			} else {

				int i = strlen(split[1]) == 1 ? *split[1] - '0' : -1;
				//check for index in bounds
				if (i >= 0 && i <= 4){
			
					//check if file is even open
					if (fileHandles[i][0] != -1){
						//shell environment
						if ((fileHandles[i][0] == 0 && memory == NULL) || (running != NULL && fileHandles[i][0] == running->id && memory != NULL)){	
							int k = 2;
							fseek(hardDisk, fileHandles[i][1], 0);
							
							int n = fileHandles[i][1] % BLOCK_SIZE;
							//write the string to file 
							while (split[k] != NULL){
								char *j = split[k];
								char r;

								//write character by character
								while (*j){
									if ((r = fgetc(hardDisk)) != EOF){

										ungetc(r, hardDisk);											

										if (*j > 31 && *j < 48 || *j > 57 && *j < 126){
											fputc(*j, hardDisk);
										} else {
											fputc(' ', hardDisk);
										}

										j++;

										n++; 
										fileHandles[i][1]++;

										//reached the end of a block, so find space for a new one
										if (n == BLOCK_SIZE - 3) {
											int ptr = (fgetc(hardDisk) - '0')*100 + (fgetc(hardDisk) - '0')*10 + (fgetc(hardDisk) - '0');
											int offset = ptr == 222 ? findHDSpace() : ptr;
											//there's enough room!
											if (offset != -1){
												fseek(hardDisk, fileHandles[i][1], 0);
												fprintf(hardDisk, "%.3d", offset);			//create pointer to new block
												fileHandles[i][1] = offset;

												//start new block				
												fseek(hardDisk, offset, 0);
												int a;
												for (a = 0; a < BLOCK_SIZE; a++) fputc('2', hardDisk);
												fseek(hardDisk, offset, 0);
												n = 0;
											} else {
												printf("Error writing: not enough hard-disk space. Closing file.\n");
												char cmd[MAX_INPUT];
												strcpy(cmd, "CLOSE ");
												strcat(cmd, split[1]);
												if (memory != NULL && running != NULL){
													pushTerminateQueue(running);
													printf("Terminating process %s.\n", running->filename);
												}
												return interpreter(cmd, memory);
											}
										} 

									} 
								}
								if (split[++k] != NULL) {
									n++; 
									fputc(' ', hardDisk); 
									fileHandles[i][1]++;

									//SUPER REDUNDANT CODE :)
									//reached the end of a block, so find space for a new one
									if (n == BLOCK_SIZE - 3) {
										int ptr = (fgetc(hardDisk) - '0')*100 + (fgetc(hardDisk) - '0')*10 + (fgetc(hardDisk) - '0');
										int offset = ptr == 222 ? findHDSpace() : ptr;	//check if we are overwriting, or first to write

										//there's enough room!
										if (offset != -1){
											fseek(hardDisk, fileHandles[i][1], 0);
											fprintf(hardDisk, "%.3d", offset);			//create pointer to new block
											fileHandles[i][1] = offset;

											//start new block				
											fseek(hardDisk, offset, 0);
											int a;
											for (a = 0; a < BLOCK_SIZE; a++) fputc('2', hardDisk);
											fseek(hardDisk, offset, 0);
											n = 0;
										} else {
											printf("Error writing: not enough hard-disk space. Closing file.\n");
											char cmd[MAX_INPUT];
											strcpy(cmd, "CLOSE ");
											strcat(cmd, split[1]);
											if (memory != NULL && running != NULL){
												pushTerminateQueue(running);
												printf("Terminating process %s.\n", running->filename);
											}
											return interpreter(cmd, memory);
										}
									} 

								}
							}

						} else {

							printf("Error writing to file. File handle owned by another process.\n");

						}

					} else {
						printf("Trying to write to a non-open file handle at index %d.\n", i);
					}

				} else {

					printf("Invalid argument.\n");

				}
			}
		//DELETE A FILE
		} else if ((strcmp(split[0], "DELETE")) == 0){
			if (split[1] == NULL){
				printf("incorrect number of arguments.\n");
			} else {
				rewind(OSFATTable);
				struct OSFAT* rec = (struct OSFAT*)malloc(sizeof(struct OSFAT));
				int address = -1;
				int n = 0;
				int j;
				int i;

				//count number of entries
				do {
					j = fread(rec, sizeof(struct OSFAT), 1, OSFATTable);
					if ((strcmp(rec->filename, split[1])) == 0) {
						//make sure file is closed !
						for (i = 0; i < 5; i++){
							if (fileHandles[i][2] == rec->address){
								if (fileHandles[i][0] != -1){
									printf("Error: file is open.\n");
									return status;
								} else {
									address = rec->address;
									break;
								}
							}
						}
					}
					if (j) n++;
				} while (j);

				if (address != -1){

					//allocate temporary array of records
					struct OSFAT* table[n - 1];
					rewind(OSFATTable);
					n = 0;
					do {
						struct OSFAT* entry = (struct OSFAT*)malloc(sizeof(struct OSFAT));
						j = fread(entry, sizeof(struct OSFAT), 1, OSFATTable);
						if (entry->address != address){
							table[n] = entry;
							n++;
						}
					} while (j);

					//overwrite FAT table with file missing
					fclose(OSFATTable); 
					OSFATTable = fopen(HD_FAT, "w+");
					for (j = 0; j < n; j++){
						fwrite(table[j], sizeof(struct OSFAT), 1, OSFATTable);
					}

					//overwrite the harddisk where file was to free up space 
					fseek(hardDisk, address, 0);
					char c;
					n = 0;
					while ((c = fgetc(hardDisk)) != EOF){
						ungetc(c, hardDisk);
						fputc('0', hardDisk);
						if (c == '1') {break;}

						//reached end of block, so follow pointer
						if (++n == BLOCK_SIZE - 3){
							int ptr = (fgetc(hardDisk) - '0')*100 + (fgetc(hardDisk) - '0')*10 + (fgetc(hardDisk) - '0');
							fseek(hardDisk, -3, SEEK_CUR);
							fprintf(hardDisk, "%.3d", 0);	//overwrite the pointer with zeros
							fseek(hardDisk, ptr, 0);
							n = 0;
						}
					}

				} else {

					printf("The file %s does not exist.\n", split[1]);

				}

			}
		//FOR GLORY: READ BACK A FILE
		} else if ((strcmp(split[0], "READ")) == 0){
			
			if (split[1] == NULL){
				printf("Incorrect number of arguments.\n");
			} else {
				rewind(OSFATTable);
				struct OSFAT* rec = (struct OSFAT*)malloc(sizeof(struct OSFAT));
				int j;
				int address = -1;
				int i;
				do {
					j = fread(rec, sizeof(struct OSFAT), 1, OSFATTable);
					if ((strcmp(rec->filename, split[1])) == 0) {
						for (i = 0; i < 5; i++){
							if (fileHandles[i][2] == rec->address){
								if (fileHandles[i][0] != -1){
									printf("Error: file is open. \n");
									return status;
								} else {
									address = rec->address; 
									break;
								}
							}
						}
					}
				} while (j);

				if (address == -1){
					printf("Error: file %s does not exist.\n", split[1]);
				} else {
					fseek(hardDisk, address, 0);
					char c;
					int n = 0;
					while ((c = fgetc(hardDisk)) != '1'){
						printf("%c", c);
						n++;
						if (n == BLOCK_SIZE - 3){
							int ptr = (fgetc(hardDisk) - '0')*100 + (fgetc(hardDisk) - '0')*10 + (fgetc(hardDisk) - '0');
							fseek(hardDisk, ptr, 0);
							n = 0;
						}
					}
					printf("\n");
				} 
			}

		//PRINT FILES IN THE OS FAT TABLE (debugging purposes)
		} else if ((strcmp(split[0], "OSFAT")) == 0){
			rewind(OSFATTable);
			struct OSFAT* rec = (struct OSFAT*)malloc(sizeof(struct OSFAT));
			fread(rec, sizeof(struct OSFAT), 1, OSFATTable);
			int j;
			do {
				if (!*rec->filename) {printf("EMPTY\n"); break;}
				printf("name: %s, start address: %d\n", rec->filename, rec->address);
				j = fread(rec, sizeof(struct OSFAT), 1, OSFATTable);
			} while (j);
		//PRINT the file handles table (debugging purposes)
		} else if ((strcmp(split[0], "HANDLES")) == 0){
			int i;
			for (i = 0; i < 5; i++){
					printf("%d) owned by: %d, current offset: %d, start address: %d\n", i, fileHandles[i][0], fileHandles[i][1], fileHandles[i][2]);
			}
		//PRINT CONTENTS OF HDD
		} else if ((strcmp(split[0], "HDD")) == 0){
			rewind(hardDisk);
			int i;
			for (i = 0; i < 1000; i++){
				printf("%c", fgetc(hardDisk));
			}
			printf("\n");
		//let system take care of command
		} else {
			system(split[0]);

		}
		
	}	
			
	return status;
}
