//////////////////////////////////////////
//                                     //
//     COMP 310 - OPERATING SYSTEMS    //
//     Assignment 4 - Part 1           //
//     Alexander Kawrykow              //
//     260324367                       //
//     Michael Shapiro		       //
//     260261525                       //
//                                     //
/////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "myKernel.c"
#include "myShell.c"
#ifndef OS_INCL
#define OS_INCL 1
#include "OS.h"
#endif

//<----MYBOOT FUNCTION---->//

void myboot(){
	//initialize RAM to NULL
	int i = 0;
	for (i = 0; i < RAM_MAX; i++){
		RAM[i] = NULL;
	}

	//now verify to see that RAM is still
	//NULL
	i = 0;
	for (i = 0; i < RAM_MAX; i++){

		//found non-NULL cell
		if (RAM[i] != NULL){
			printf("RAM damaged at address %d. Exiting...\n", i);
			exit(EXIT_FAILURE);
		}

	}
	
	//initialize the harddrive
	hardDisk = fopen(HD_FILE, "w+");
	OSFATTable = fopen(HD_FAT, "w+");
	if (hardDisk == NULL || OSFATTable == NULL){
		printf("Error initializing hard-disk. Exiting...\n");
		exit(EXIT_FAILURE);
	} else {

		//write the 10000 zero's
		i = 0;
		for (i = 0; i < 10000; i++){
			fprintf(hardDisk, "%c", '0');
		}

		//verify that they are all there
		rewind(hardDisk);

		char c;
		i = 0;
		while ((c = fgetc(hardDisk)) != EOF){
			if (c != '0'){
				printf("myLinux is unable to format harddisk. Exiting...\n");
				exit(EXIT_FAILURE);
			} else {
				i++;
			}
		}
		
		if (i != 10000) {
			printf("myLinux is unable to format harddisk. Exiting...\n");
			exit(EXIT_FAILURE);
		}

		//reposition pointer
		rewind(hardDisk);

		//initialize the file handles table 
		for (i = 0; i < 5; i++){
			fileHandles[i][0] = -1;  //not in use 
		}
		
		//everything went smoothly... welcome 
		printf("Welcome to myLinux.\n\n");

	}
}


//<-----MAIN FUNCTION----->//

int main(int argc, char *argv[]){
	myboot();	
	return myKernel(argc, argv);
}

