//////////////////////////////////////////
//                                     //
//     COMP 310 - OPERATING SYSTEMS    //
//     Assignment 4 - Part 1           //
//     Alexander Kawrykow              //
//     260324367                       //
//     Michael Shapiro		       //
//     260261525                       //
//                                     //
/////////////////////////////////////////

#ifndef OS_INCL
#define OS_INCL 1
#include "OS.h"
#endif

//create a CPU

struct CPU* newCPU(){
	struct CPU* new = (struct CPU* )malloc(sizeof(struct CPU));
	int i;
	for (i = 0; i < HEAP_SIZE; i++){
		new->memory[i] = (char *)malloc(MAX_INPUT);
	}
	return new;
}

//create a backingstore record

struct bs_rec* newBS(){
	struct bs_rec* new = (struct bs_rec*)malloc(sizeof(struct bs_rec));
	int i;
	for (i = 0; i < FRAMESIZE; i++){
		new->command[i][0] = '\0';
	}	
	return new;
}

//return reference to a new PCB created, if there is space 
struct PCB* newPCB(char *fname, int s, int c, int l){
	
	struct PCB* new = (struct PCB* )malloc(sizeof(struct PCB));
	
	//not enough space 
	if (new == NULL){
		printf("Error: not enough memory. Free up some space first.\n");
	} else {
		strcpy(new->filename, fname);
		new->start = s;
		new->length = l;
		new->current = c;
		int i;
		for (i = 0; i < HEAP_SIZE; i++){
			new->heap[i] = (char *)malloc(MAX_INPUT);
		}

		//fill page table 
		for (i = 0; i < PAGETABLE_SIZE; i++){
			struct page_rec* newPage = (struct page_rec*)malloc(sizeof(struct page_rec));
			newPage->inRAM = 0;
			newPage->wasModified = 0;
			newPage->baseAddress = -1;
			new->pageTable[i] = newPage;
		}
		new->next = NULL;
	}

	return new;
}

//add a PCB to the end of a given queue 
struct PCB* enqueuePCB(struct PCB* queue, struct PCB* e){

	if (queue == NULL){
		return e;
	} else {

		struct PCB* cur = queue;
		while (cur->next){

			//avoid duplicate insertions
			if (cur == e) return queue;

			cur = cur->next;
		}

		//avoid duplicate insertions 
		if (cur != e){
			cur->next = e;
			e->next = NULL;
		}
		return queue;
	}

}

//enqueue a PCB in the ready queue 
void pushReadyQueue(struct PCB* e){
	readyHead = enqueuePCB(readyHead, e);
	readyTail = e;
}

//remove a PCB from the ready queue 
struct PCB* dequeuePCB(struct PCB* queue, struct PCB* e){
	if (queue != NULL){
		struct PCB* cur = queue;
		if (cur == e){
			return cur->next;
		} else {
			struct PCB* prev = cur;
			cur = cur->next;
			while (cur->next){
				if (cur == e){
					prev->next = cur->next;
					return queue;
				}
				prev = cur;
				cur = cur->next;
			}
			if (cur == e){
				prev->next = NULL;
			}
			return queue;
		}
	}
}

//remove a PCB from the ready queue and enqueue it
//in the terminating queue 
void pushTerminateQueue(struct PCB* e){
	readyHead = dequeuePCB(readyHead, e);
	e->next = NULL;
	terminatingHead = enqueuePCB(terminatingHead, e);
	terminatingTail = e;
}

//terminate a PCB
//remove its program from RAM and free it 		
void terminatePCB(struct PCB *e){
	if (e != NULL){
		struct page_rec* page;
		int i;
		while ((page = pageInRam(e)) != NULL){
			for (i = page->baseAddress; i < page->baseAddress + 4; i++){
				free(RAM[i]);
				RAM[i] = NULL;
			}
			page->inRAM = 0;
		}

		//remove the file from backing store
		char remove[MAX_INPUT];
		strcpy(remove, "rm ./BACKINGSTORE/");
		strcat(remove, e->filename);
		strcat(remove, ".BS");
		system(remove);
		free(e);
	}
}


//for debugging, print the filenames
//of all processes in a queue 
void printQueue(struct PCB* queue){
	if (queue){
		printf("[ ");
		struct PCB* cur = queue;
		while (cur){
			printf("%s", cur->filename);
			cur = cur->next;
			if (cur){
				printf(", ");
			} else {
				printf(" ]");
			}
		}
	}
}

//move the running counter to the next process
//in the ready queue 
void nextReadyQueue(){
	runningPrev = running;
	
	if (running != NULL){
		running = (running->next == NULL ? readyHead : running->next);
	} else {
		running = readyHead;
	}
	
}

//switch in a PCB to be executed
void taskSwitchIn(struct PCB* e){
	if (e != NULL && inQueue(readyHead, e)){
		CPU->returnCode = 0;		//reset CPU's return code
		CPU->pc = e->current;	//set PC to PCB's PC
		int i;
		for (i = 0; i < HEAP_SIZE; i++){
			if (e->heap[i] != NULL){
				strcpy(CPU->memory[i], e->heap[i]);	//copy heap into CPU's registers
			}
		}
	}
}

//switch out a PCB
void taskSwitchOut(struct PCB* e){
	if (e != NULL){
		int i;
		for (i = 0; i < HEAP_SIZE; i++){
			if (CPU->memory[i] != NULL){
				strcpy(e->heap[i], CPU->memory[i]);	//copy CPU's memory into heap space 
			}
		}
		e->current = CPU->pc;	//let the PCB remember where it left off executing 
	}
}

//set the quanta for a specific PCB
void setQuanta(int q){
	CPU->quanta = q;
}

//for debugging purposes, print a detailed
//view of a PCB's pagetable
void printPageTable(struct PCB* e){

	int i;

	for (i = 0; i < PAGETABLE_SIZE; i++){
		printf("%d) IN RAM: %d, base address: %d\n", i, (e->pageTable[i])->inRAM, (e->pageTable[i])->baseAddress);
	}
}


//run the given PCB
void runForQuanta(struct PCB* e){
	if (e != NULL){

		int j = 0;
		int i;

		//only execute instructions if PC has not passed end of program
		//and PCB has not used up all of its quanta 
		//and did not detect an EXIT or LOGOUT
		while (j < CPU->quanta && inQueue(readyHead, e)){
			//if this PCB has been victimized, find some freespace to reload
			//the current page. if there is no space, victimize another PCB
			if (!((e->pageTable[e->curPage])->inRAM)){
				int freeSpace = findRAMSpace(FRAMESIZE);

				//not enough space, so victimize someone else 
				if (freeSpace == -1){
					struct PCB* victim = victimize(readyHead);
					struct page_rec* victimPage = pageInRam(victim);
					freeSpace = victimPage->baseAddress;

					for (i = 0; i < FRAMESIZE/4; i++){
						victimPage->inRAM = 0;
						victimPage = pageInRam(victim);
					}
				}

				//read the frame back from the backingstore
				fseek(e->backingStore, e->curPage * sizeof(struct bs_rec), 0);
				struct bs_rec* frame[FRAMESIZE/4];
				for (i = 0; i < FRAMESIZE/4; i++){
					struct bs_rec* page = (struct bs_rec*)malloc(sizeof(struct bs_rec));
					fread(page, sizeof(struct bs_rec), 1, e->backingStore);	
					frame[i] = page;
				}

				//copy commands back into ram
				for (i = 0; i < FRAMESIZE; i++){
					free(RAM[freeSpace + i]);
					RAM[freeSpace + i] = (char *)malloc(sizeof(frame[i/4]->command[i%4]));
					strcpy(RAM[freeSpace + i], frame[i/4]->command[i%4]);
				}

				//update page table accordingly
				for (i = 0; i < FRAMESIZE/4; i++){
					(e->pageTable[e->curPage + i])->inRAM = 1;
					(e->pageTable[e->curPage + i])->baseAddress = freeSpace + i*4;
				}

				//start executing where the frame was reloaded in ram
				CPU->pc = freeSpace + (e->current - e->start);
				e->start = freeSpace;
			}

			//reached the end of the current page 
			if (CPU->pc == (e->pageTable[e->curPage])->baseAddress + 4){

				//not at the end of the program
				if (e->curPage++ < e->maxPages - 1){

					//page is already in RAM
					if ((e->pageTable[e->curPage])->inRAM){

						//just update program counter and resume
						CPU->pc = (e->pageTable[e->curPage])->baseAddress;

					//at the end of a frame
					} else {

						//load the new frame and do a page swap

						fseek(e->backingStore, e->curPage * sizeof(struct bs_rec), 0);
						struct bs_rec* frame[FRAMESIZE/4];
						for (i = 0; i < FRAMESIZE/4; i++){
							struct bs_rec* page = (struct bs_rec*)malloc(sizeof(struct bs_rec));
							fread(page, sizeof(struct bs_rec), 1, e->backingStore);	
							frame[i] = page;
						}

						//copy instructions into ram

						for (i = 0; i < FRAMESIZE; i++){
							free(RAM[(e->pageTable[e->curPage - FRAMESIZE/4])->baseAddress + i]);
							RAM[(e->pageTable[e->curPage - FRAMESIZE/4])->baseAddress + i] = 
										(char *)malloc(sizeof(frame[i/4]->command[i%4]));
							strcpy(RAM[(e->pageTable[e->curPage - FRAMESIZE/4])->baseAddress + i], 
										frame[i/4]->command[i%4]);

						}

						//update the page table accordingly

						for (i = 0; i < FRAMESIZE/4; i++){
							(e->pageTable[e->curPage - FRAMESIZE/4 + i])->inRAM = 0;
							(e->pageTable[e->curPage + i])->inRAM = 1;
							(e->pageTable[e->curPage + i])->baseAddress = 
								(e->pageTable[e->curPage - FRAMESIZE/4 + i])->baseAddress;
						}

						//reset cpu's pc to the beginning of the frame for next time 

						CPU->pc =  (e->pageTable[e->curPage - FRAMESIZE/4])->baseAddress;

						break; 
					}
				} else {

					//reached end of program
					pushTerminateQueue(e);
					break;
				}
					
			}

			//not a page fault and has quanta left, so just execute the instruction
			if (RAM[CPU->pc] != NULL && (strcmp(RAM[CPU->pc], "")) != 0){
				CPU->returnCode = interpreter(RAM[CPU->pc], CPU->memory);
			}
			j++;
			CPU->pc ++;

			//if an EXIT or LOGOUT was found, or reached end of program,
			//put this PCB in the terminating queue 
			if (CPU->returnCode == -1){
				pushTerminateQueue(e);
				break;
			}
		}

	}
}

//go along the terminating queue and 
//terminate all processes in the queue 
void terminateProcesses(){
	struct PCB* temp;

	//if running is to be terminated, then 
	//switch it to previous so next time 
	//nextReadyQueue() is called, running is
	//move to appropriate PCB
	if (inQueue(terminatingHead, running)){
		if (readyHead == NULL) {
			running = NULL;
		} else {
			running = runningPrev;
		}
	}

	while (terminatingHead){
		temp = terminatingHead->next;
		terminatePCB(terminatingHead);
		terminatingHead = temp;
	}
}

//debugging function to determine whether
//a PCB is in a queue 
int inQueue(struct PCB* queue, struct PCB* e){
	struct PCB* cur = queue;
	while (cur){
		if (cur == e) return 1;
		cur = cur->next;
	}
	return 0;
}

//helper function to return the size of a queue
int sizeOfQueue(struct PCB* queue){
	struct PCB* cur = queue;
	int i = 0;
	while (cur){
		i++;
		cur = cur->next;
	}
	return i;
}

//enqueue a PCB in the loading queue 
void pushLoadingQueue(struct PCB* e){
	loadingHead = enqueuePCB(loadingHead, e);
	loadingTail = e;
}

//return page if PCB has a page in RAM
struct page_rec* pageInRam(struct PCB* e){ 

	if (e != NULL){
		//starting at oldest pages first, look for 
		//first page in ram 	
		int i;
		for (i = 0; i < PAGETABLE_SIZE; i++){
			if (e->pageTable[i] != NULL && (e->pageTable[i])->inRAM == 1) return e->pageTable[i];
		}
		return NULL;
	} 
}

//select an appropriate page-victim
//STRATEGY: START LOOKING AT PCB THAT WAS 
//MOST RECENTLY EXECUTED, THEN THE ONE BEFORE THAT,
//ETC
struct PCB* victimize(struct PCB* queue){

	//keep an array of PCB's for easy back-tracking
	int size = sizeOfQueue(queue);
	struct PCB* allPCBS[size];
	struct PCB* cur = queue;
	int i = 0;
	while (cur){
		allPCBS[i] = cur;
		cur = cur->next;
		i++;
	}

	/*METHOD 1 - START AT TAIL OF READY QUEUE AND WORK TOWARDS HEAD
	while (cur != queue){
		if (pageInRam(cur)){
			return cur;
		} else {
			cur = allPCBS[i--];
		}
	}*/

	//METHOD 2 - GO TO MOST RECENTLY EXECUTED AND 
	//WORK WAY BACK TIL LEAST RECENTLY EXECUTED

	cur = queue;
	i = 0;
	while (cur != running){
		cur = cur->next;
		i++;
	}
	
	int startIndex = i;
	
	do {
		if (pageInRam(cur)) return cur;
		if (i > 0) i--; else i = size - 1;
		cur = allPCBS[i];
	} while (i != startIndex);

	//NOTE: THIS SHOULD NEVER HAPPEN
	return NULL;
}

//extract a PCB from the loading queue
//and load its first frame into ram

void extractLoadingQueue(){
	
	if (loadingHead != NULL){

		int i;

		//take out one PCB from the loading queue
		struct PCB* nextLoad = loadingHead;
		loadingHead = loadingHead->next;
		nextLoad->next = NULL;
		nextLoad->curPage = 0;

		struct bs_rec* frame[FRAMESIZE/4];

		//read first frame from file 
		for (i = 0; i < FRAMESIZE/4; i++){
			struct bs_rec* page = (struct bs_rec*)malloc(sizeof(struct bs_rec));
			fread(page, sizeof(struct bs_rec), 1, nextLoad->backingStore);	
			frame[i] = page;
		}		

		//attempt to load first page into ram
		int freeSpace = findRAMSpace(FRAMESIZE);

		//not enough space, so must victimize
		if (freeSpace == -1){ 
			struct PCB* victim = victimize(readyHead);
			struct page_rec* victimPage = pageInRam(victim);
			if (victimPage != NULL){
				freeSpace = victimPage->baseAddress;

				for (i = 0; i < FRAMESIZE/4; i++){
					victimPage->inRAM = 0;
					victimPage = pageInRam(victim);
				}
	
			} else {
	
				//shouldnt ever happen, but if theres no enough room for 
				//any frames this might happen 
				return;
			}
			
		}

		//copy instructions into ram

		for (i = 0; i < FRAMESIZE; i++){
			RAM[freeSpace+i] = (char *)malloc(sizeof(frame[i/4] -> command[i%4]));
			strcpy(RAM[freeSpace+i], frame[i/4]->command[i%4]);
		}

		//update page table accordingly 

		for (i = 0; i < FRAMESIZE/4; i++){
			(nextLoad->pageTable[i])->inRAM = 1;
			(nextLoad->pageTable[i])->baseAddress = freeSpace + i*4;
		}

		//put nextLoad into ready queue
		nextLoad->start = freeSpace; 
		nextLoad->current = freeSpace;
		pushReadyQueue(nextLoad);
	}
		
}

//enqueue a PCB in the loading queue 
void pushWaitingQueue(struct PCB* e){
	readyHead = dequeuePCB(readyHead, e);
	e->next = NULL;
	waitingHead = enqueuePCB(waitingHead, e);
	waitingTail = e;
}


//go through the waiting queue to check for any processes
//whose requested resource has become available		
void checkWaitingQueue(){
	struct PCB* cur = waitingHead;
	while (cur){
		if (fileHandles[cur->requestId][0] == -1){
			pushReadyQueue(cur);
			cur->current--;	 //make sure process re-executes last instruction
			waitingHead = dequeuePCB(waitingHead, cur);
		}
		cur = cur->next;
	}
}

//<------MYKERNEL FUNCTION----------->//

int myKernel(int argc, char *argv[]){
	
	//format ram

	ramFormat.zeroPageSize = 10;
	ramFormat.freeSpaceSize = RAM_MAX - 10;
	FRAMESIZE = 4; //default size

	//check for proper switches
	int i;
	int f;
	int s; 

	for (i = 1; i < argc; i++){
		char x[MAX_INPUT];
		//found -f:NUMBER within range, so set new boundary
		if ((sscanf(argv[i], "-f:%d", &f)) == 1 && (f > 0 && f < RAM_MAX - 10) &&
			(sprintf(x, "%d", f) == strlen(argv[i])-3)) ramFormat.freeSpaceSize = f;

		//found -framesize:NUMBER within range so set new framesize
		if ((sscanf(argv[i], "-framesize:%d", &s)) == 1 && (sprintf(x, "%d", s) == strlen(argv[i])-11) &&
			 (s > 0 && s < ramFormat.freeSpaceSize && (s%4) == 0)) FRAMESIZE = s;

	}

	//initialize run-time environment

	readyHead = NULL;
	readyTail = NULL; 
	running = NULL;
	terminatingHead = NULL; 
	terminatingTail = NULL;
	loadingHead = NULL;
	loadingTail = NULL;
	CPU = newCPU();
	
	//call login script

	while (!login());

	//initialize shell 
	if (!initMysh(argc, argv)){

		int returnCode;

		//execute one command from the user
		//then extract ONE pcb from loading queue and load its first page into ram
		//then give ONE quanta to ONE process in the ready queue,
		//then remove all processes in the waiting queue with a freed requested resource
		//then terminate all processes in the terminating queue
		//then return to user 
		do {	
			returnCode = mysh();
			extractLoadingQueue();
			nextReadyQueue();
			taskSwitchIn(running);
			setQuanta(3);
			runForQuanta(running);
			taskSwitchOut(running);
			checkWaitingQueue();
			terminateProcesses();

		} while (returnCode != -1);

		//CLOSE HARDDRIVE FILE POINTERS
		fclose(hardDisk);
		fclose(OSFATTable);

	}		

	return 0;
}

//<----LOGIN FUNCTION----->//

int login(){
	FILE *f = fopen("pass.csv", "rt");

	//could not load file 
	if (f == NULL){
		printf("Could not load user list\n");
	} else {

		//prompt user to enter name 
		printf("username: ");
		char user[MAX_INPUT];
		char *u;
		fgets(user, MAX_INPUT, stdin);

		//prompt user to enter password
		printf("password: ");
		char password[MAX_INPUT];
		char *p;
		fgets(password, MAX_INPUT, stdin);
		
		//malformed input 
		if ((u = strtok(user, "\n")) == NULL || (p = strtok(password, "\n")) == NULL) return 0;	
		
		//now go through file line by line to check for match
		char line[MAX_INPUT];
		char *l;

		while (fgets(line, MAX_INPUT, f)){
			l = strtok(line, ",");
			if (l && strcmp(l, u) == 0){
				if ((l = strtok(NULL, ",")) && (strcmp(strtok(l, "\n"), p) == 0)) {
					fclose(f);
					return 1;	//found a match
				}
			}
		}

		//close the file
		fclose(f);
	}

	//no match found
	printf("Invalid username or password\n");
	return 0;
}

//find the first available contiguous block of ram space 
//to fit in a program of given size
//a -1 return means no space was available 
int findRAMSpace(int size){

	//program is bigger than free space 
	if (size > ramFormat.freeSpaceSize){
		return -1;
	} else {
		int i;
		for (i = ramFormat.zeroPageSize - 1; i < ramFormat.zeroPageSize + ramFormat.freeSpaceSize - size; i++){

			//first NULL cell 
			if (RAM[i] == NULL){
				int j;
				int found = 1;

				//starting from NULL cell, loop through 'size' more cells
				//to see if they are also NULL 
				for (j = 0; j < size; j++){
					if (RAM[i+j] != NULL) {
						found = 0;
						i += j;
						break;
					}
				}
				if (found) return i;
			}
		}

		//no space found 
		return -1;
	}
}

//look for the first empty spot in the harddisk to start writing to 
int findHDSpace(){
	char c;
	int i = 0;
	rewind(hardDisk);
	while (i < 1000 && (c = fgetc(hardDisk)) != EOF){
		if (c == '0' && i % BLOCK_SIZE < BLOCK_SIZE - 3) return i;
		i++;
	}
	return -1;
}
