//////////////////////////////////////////
//                                     //
//     COMP 310 - OPERATING SYSTEMS    //
//     Assignment 4 - Part 1           //
//     Alexander Kawrykow              //
//     260324367                       //
//     Michael Shapiro		       //
//     260261525                       //
//                                     //
/////////////////////////////////////////

//define constants 
#define MAX_INPUT 100
#define HEAP_SIZE 20
#define RAM_MAX 210

//create global pointers
char *RAM[210];
int FRAMESIZE;
int PAGETABLE_SIZE = 100;

//<----STRUCTS---->//

//create CPU struct
struct CPU
{
        int quanta;
        int returnCode;
        int pc;           	// program counter
        char *memory[HEAP_SIZE]; // to simulate the CPU registers by copying PCB heap (cell by cell)
} *CPU;

struct CPU* newCPU();

//create the ram structure struct
struct RAM_STRUCTURE
{
        int freeSpaceSize;
        int zeroPageSize;
} ramFormat;

//create backing store struct

struct bs_rec
{
       char command[4][100];
};

//create page struct 

struct page_rec
{
        int inRAM; 	 // boolean true if page in RAM, false if page in backing store
        int wasModified; // will not be used in this assignment
        int baseAddress; // the index number of the RAM array cell of the frame
};

//create PCB struct
struct PCB
{
	int id;		    // unique id for this process
        char filename[50];  // stores the filename of the script loaded into memory
        int start;          // start address – where it is loaded into RAM
        int length;         // the number of instructions
        int current;        // current instruction being executed
        char *heap[20];     // implemented as a list of Shell Memory variables and values
	FILE* backingStore; // pointer to the backingstore
	long maxPages;      // how many pages needed to hold program
	struct page_rec* pageTable[100]; 
	int curPage;
	int requestId;
        struct PCB *next;   // next node in the linked-list
} *readyHead, *readyTail, *running, *runningPrev, *terminatingHead, 
*terminatingTail, *loadingHead, *loadingTail, *waitingHead, *waitingTail;

//define linked list and node 
typedef struct ll_node {
	char var[200];
	char value[200];
	struct ll_node* next;
} node, linkedlist;


//<---PCB AND QUEUE FUNCTIONALITY--->//

struct bs_rec* newBS();
struct PCB* newPCB(char f[], int s, int l, int c);
struct PCB* enqueuePCB(struct PCB* queue, struct PCB* e);
void pushReadyQueue(struct PCB* e);
struct PCB* dequeuePCB(struct PCB* queue, struct PCB* e);
void pushTerminateQueue(struct PCB* e);
void terminatePCB(struct PCB* e);
void printQueue(struct PCB* e);
int inQueue(struct PCB* queue, struct PCB* e);
void nextReadyQueue(void);	
void taskSwitchIn(struct PCB* e);
void taskSwitchOut(struct PCB* e);
void setQuanta(int q);
void runForQuanta(struct PCB* e);
void terminateProcesses(void);
int findRamSpace(int s);
void pushLoadingQueue(struct PCB* e);
struct PCB* victimize(struct PCB* queue);
struct page_rec* pageInRam(struct PCB* e);


//<--- LINKED LIST FUNCTIONALITY --->//

node* newNode(char *v, char *val);
void addNode(linkedlist* list, node* e);
node *findNode(linkedlist* list, char* v);
void printNode(node *n);
void printList(linkedlist *list);

//global shellMemory pointer 	
linkedlist* shellMemory;

//FILE SYSTEMS

char* HD_FILE  = "OSFILES.txt";
char* HD_FAT = "OSFAT.txt";
FILE *hardDisk;
FILE *OSFATTable;
int BLOCK_SIZE = 10;

struct OSFAT
{
    char filename[20]; // file names are at most 19 characters with /0
    int address; // an offset value from the start of the simulated disk
};

int fileHandles[5][3];
int processCount = 1;

int findHDSpace();


